/**
 *
 * $Id: VkFileSelectionDialog.h,v 1.2 1995/04/20 05:32:07 toshok Exp $
 *
 * This file contains the class definition for the 
 * VkFileSelectionDialog class.
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc
 * All Rights Reserved
 *
 **/

#ifndef VKFILESELECTIONDIALOG_H
#define VKFILESELECTIONDIALOG_H

#include <Xm/FileSB.h>
#include <Vk/VkConfig.h>
#include <Vk/VkDialogManager.h>

class VkFileSelectionDialog : public VkDialogManager {
private:

    static void _setFilenameCallback(Widget, XtPointer, XtPointer);
    void setFilenameCallback(char *new_filename);

protected:
  
    char *_directory;
    char *_pattern;
    char *_selection;
    char *_filename;

public:

    VkFileSelectionDialog(const char *name);
    virtual Widget createDialog(Widget parent);
    const char *className();

    void setDirectory(const char *directory);
    void setFilterPattern(const char *pattern);
    void setSelection(const char *selection);

    const char *fileName();
};

#define theFileSelectionDialog _theFileSelectionDialogManager

extern VkFileSelectionDialog *_theFileSelectionDialogManager;

#endif // VKFILESELECTIONDIALOG_H
