/** 
 *
 * $Id: VkInput.h,v 1.2 1995/04/20 05:32:07 toshok Exp $
 *
 * This file contains the class which encapsulates
 * input callbacks from file descriptors.
 * 
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc
 * All Right Reserved
 *
 **/

#ifndef VKINPUT_H
#define VKINPUT_H

#include <X11/Intrinsic.h>
#include <Vk/VkConfig.h>
#include <Vk/VkCallbackObject.h>

class VkInput : public VkCallbackObject {
private:
    static void inputHandler(XtPointer clientData, int *source, XtInputId *id);

protected:
    XtInputId _id;
    int _fd;

public:
    VkInput();

    virtual ~VkInput();

    void attach(int fd, XtInputMask mask);
    void remove();

    int fd();
    int id();

    static const char *const inputCallback;
};

#endif // VKINPUT_H
