/**
 *  
 * $Id: VkNameList.h,v 1.2 1995/04/20 05:32:07 toshok Exp $
 *
 * This file contains the definition for the VkNameList
 * class, which gives an interface to a list of strings.
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc
 * All Rights Reserved
 *
 **/

#ifndef VKNAMELIST_H
#define VKNAMELIST_H

#include <Xm/Xm.h>
#include <Vk/VkConfig.h>

class VkNameList {
private:
    char **_contents;
    int _numberOfElements;
    int _maxNumberOfElements;

public:
    VkNameList();
    VkNameList(const VkNameList& givenList);
    VkNameList(char *name);

    ~VkNameList();

    void add(char *name);
    void add(const VkNameList &givenList);
    void remove(char *name);

    VkNameList& operator=(const VkNameList &givenList);

    void sort();
    void reverse();
    void removeDuplicates();

    int size();
    int exists(char *name);
    char *operator[](int index);
    
    VkNameList operator[](char *subString);

    int operator==(const VkNameList&givenList);

    char *mostCommonString();
    VkNameList *completeName(char*name,
			     char * &completedName,
			     int &nMatching);

    operator char**();

    operator XmStringTable ();
};

#endif // VKNAMELIST_H
