/**
 *
 * $Id: VkOptionMenu.h,v 1.2 1995/04/20 05:32:07 toshok Exp $
 *
 * This file contains the class definition for the VkOptionMenu class.
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc
 * All Rights Reserved
 *
 **/

#ifndef VKOPTIONMENU_H
#define VKOPTIONMENU_H

#include <Xm/RowColumn.h>
#include <Vk/VkConfig.h>
#include <Vk/VkMenu.h>

class VkOptionMenu : public VkMenu {
private:
  Widget _pulldown;
  
public:
  VkOptionMenu(Widget parent,
	       VkMenuDesc *menuDesc,
	       XtPointer defaultClientData = NULL);
  
  VkOptionMenu(Widget parent,
	       const char *name = "optionMenu",
	       VkMenuDesc *menuDesc = NULL,
	       XtPointer defaultClientData = NULL);
  
  void set(char *name);
  void set (int index);
  void set (VkMenuItem *item);
  
  int getIndex();
  
  VkMenuItem *getItem();
  
  void forceWidth(int width);
  
  VkMenuItemType menuType();

  const char *className();

  Boolean isContainer();

  void setLabel(const char *str);

  void _instantiate(Widget parent);

  Widget pulldown();
};


#endif // VKOPTIONMENU_H
