/**
 *
 * $Id: VkSubProcess.h,v 1.2 1995/04/20 05:32:07 toshok Exp $
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc.
 * All Rights Reserved
 *
 **/

#ifndef VKSUBPROCESS_H
#define VKSUBPROCESS_H

#include <Vk/VkConfig.h>
#include <Vk/VkCallbackObject.h>
#include <Vk/VkPipe.h>
#include <Vk/VkNameList.h>
#include <signal.h>

class VkSubProcess : public VkCallbackObject {
private:
    pid_t _pid;
    char *_cmd;
    VkNameList *_args;

    int _killMeOnExit;
    int _redirectIn;

    int stdinFd;

    VkPipe *_stdout;
    VkPipe *_stderr;
    VkPipe *_stdin;

public:
    VkSubProcess(char *cmd,
		 VkNameList *argv,
		 int killChildOnExit,
		 int redirectIn);

    virtual ~VkSubProcess();

    pid_t pid();
    int exitStatus();
    int stdinfd();
    VkPipe *getStdoutPipe();
    VkPipe *getStderrPipe();

    void signal(int sig);
    void kill(int sig = SIGTERM);
    void run(void);
};

#endif // VKSUBPROCESS_H
