/**
 *
 * $Id: VkWidgetList.h,v 1.4 1995/04/20 05:32:07 toshok Exp $
 *
 * This file contains the class declaration for
 * the VkWidgetList class, which contains a dynamically
 * resizable array of widgets.
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc.
 * All Rights Reserved
 *
 **/

#ifndef VKWIDGETLIST_H
#define VKWIDGETLIST_H

#include <X11/Intrinsic.h>
#include <Vk/VkConfig.h>
#include <Vk/VkComponent.h>

class VkWidgetList {
private:
    Widget *_items;
    int _numberOfItems;
    int _maxNumberOfItems;

    void doReallocIfNecessary();

public:
    VkWidgetList();
  
    virtual void add(Widget newItem);
    virtual void add(VkComponent *component);

    virtual void remove(Widget item);
    virtual void remove(VkComponent *component);

    virtual void removeLast();
    virtual void removeFirst();

    int size() { return _numberOfItems; }
    int indexOfItem(Widget item);

    Widget operator[](int index) const;
};

#endif // VKWIDGETLIST_H
