/**
 *
 * $Id: VkWindow.h,v 1.3 1995/04/20 05:32:07 toshok Exp $
 *
 * This file contains the class definition for the VkWindow class.
 * This class differs from the VkSimpleWindow class in that you
 * can put menu bars into Windows, but not into SimpleWindows.
 * 
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc
 *
 **/

#ifndef VKWINDOW_H
#define VKWINDOW_H

#include <Vk/VkConfig.h>
#include <Vk/VkApp.h>
#include <Vk/VkSimpleWindow.h>
#include <Vk/VkMenuBar.h>

class VkWindow : public VkSimpleWindow {

private:
  VkMenuBar *_menuBar;
  Boolean _menuBarInstantiated;
  
public:
    VkWindow(const char *name,
	     ArgList args = NULL,
	     Cardinal argCount = 0);
    
    virtual ~VkWindow();
    
    virtual const char *className();
    
    void addMenuPane();
    void setMenuBar(VkMenuBar *menuObj);
    void setMenuBar(VkMenuDesc *menuDesc);
    virtual VkMenuBar *menu() const;
    
    VkSubMenu *addMenuPane(const char *name);
    VkSubMenu *addMenuPane(const char *name, VkMenuDesc *menudesc);
    
    VkRadioSubMenu *addRadioMenuPane(const char *name);
    VkRadioSubMenu *addRadioMenuPane(const char *name,
				     VkMenuDesc *menudesc);
    
    virtual void show();
};

#endif /* VKWINDOW_H */


