/**
 *
 * $Id: VkCallbackObject.h,v 1.4 1995/04/20 05:32:07 toshok Exp $
 *
 * This file defines the class structure for the
 * VkCallbackObject class, which forms the base class
 * for all of the user interface components in the
 * Open ViewKit library.
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc
 * All Rights Reserved
 *
 **/

#ifndef VKCALLBACKOBJECT_H
#define VKCALLBACKOBJECT_H

#include <Vk/VkConfig.h>
#include <stdio.h> /* for NULL */

class VkCallbackObject; /* Must be defined previous to the typdef's... I'll define it later */

typedef void (VkCallbackObject::*VkCallbackMethod)(VkCallbackObject *obj,
						   void *clientData,
						   void *callData);

typedef void (*VkCallbackFunction)(VkCallbackObject *obj,
				   void *clientData,
				   void *callData);

enum CallbackType {VKCALLBACKFUNCTION = 0,  VKCALLBACKMETHOD};

class VkCallbackList;

class VkCallbackObject {
private:
  int numberOfCallbackLists;
  int maxCallbackLists;
  VkCallbackList **callbackLists;

  void addNewCallbackList(const char *name);
  
protected:
  void callCallbacks(const char * const callback,
		     void *callData);

  VkCallbackObject();
public:

  // stuff for use with member functions 
  void addCallback (const char *name,
		    VkCallbackObject *component,
		    VkCallbackMethod callbackFunction,
		    void *clientData = NULL);

  void removeCallback (const char *name,
		       VkCallbackObject *otherObject,
		       VkCallbackMethod memberFunction,
		       void *clientData = NULL);

  // stuff for use with non-member functions

  void addCallback (const char *name,
		    VkCallbackFunction callbackFunction,
		    void *clientData = NULL);

  void removeCallback (const char *name,
		       VkCallbackFunction callbackFunction,
		       void *clientData = NULL);

  // stuff for both member and non-member functions

  void removeAllCallbacks(void);  // remove all callbacks from an object
  void removeAllCallbacks(VkCallbackObject *obj); /* removes callbacks registered
						     by obj */

};

#endif /* VKCALLBACKOBJECT_H */
