/**
 *
 * $Id: VkCheckBox.h,v 1.2 1995/04/20 05:32:07 toshok Exp $
 *
 * This file contains the class declaration for the
 * VkCheckBox class, which allows programmers to
 * create groups of check-box type toggle buttons
 * with a title and frame surrounding them.
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc.
 * All Rights Reserved
 *
 **/

#ifndef VKCHECKBOX_H
#define VKCHECKBOX_H

#include <Vk/VkConfig.h>
#include <Vk/VkComponent.h>
#include <Vk/VkWidgetList.h>

class VkCheckBox : public VkComponent {
private:
    static void valueChangedCallback(Widget, XtPointer, XtPointer);

protected:
    VkWidgetList *_widgetList;
    Widget _rc;
    Widget _label;

public:
    VkCheckBox(const char *name, Widget parent);

    const char *className();

    Widget addItem(char *name, 
		   Boolean state = FALSE,
		   XtCallbackProc proc = NULL,
		   XtPointer clientDate = NULL);

    void setValue(int index, Boolean newValue);
    void setValues(Boolean *values, int numValues);

    int getValue(int index);

    virtual void valueChanged(int index, Boolean newValue);

    static const char *const itemChangedCallback;
    
};

#endif // VKCHECKBOX_H
