/**
 *
 * $Id: VkFont.h,v 1.4 1995/04/20 05:32:07 toshok Exp $
 *
 * This file contains the class description of 
 * VkFont, which encapsulates screen (as well
 * as printer) fonts, and provides an interface
 * to manipulating them.  The majority of operations,
 * however, should be performed with the VkFontManager
 * instead of individual fonts, so the application
 * maintains information of these changes.
 *
 * This class is roughly analogous to NSFont in
 * the OpenStep Specification, which inspired it.
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc.
 * All Rights Reserved
 *
 **/

#ifndef VKFONT_H
#define VKFONT_H

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <stdio.h>
#include <Vk/VkConfig.h>

typedef unsigned int VkFontTraitMask;

/* for now we only support the following traits */
/* should change as soon as more of the font machinery
   is in place  -- Chris */

#define VK_ITALIC_FONT_MASK 1
#define VK_BOLD_FONT_MASK 2

class VkFont {
private:
    XFontStruct *fs;

    char *_fontName;
    float _pointSize;
    char *_familyName;
    char *_screenName;

    Boolean _hasAFM;

    Boolean parseAFM(FILE *fp);

public:
    VkFont (char *xlfd, 
	    char *fontName = "Courier", 
	    float pointSize = 11.0,
	    VkFontTraitMask traitMask = 0);

    Boolean hasAFMDictionary();
    const char *displayName();
    const char *familyName();
    
    float pointSize();
    
    VkFont *printerFont();
    XFontStruct *screenFont();
    
    float stringWidth(char *string);
    float stringWidth(char *string, int num_chars);

    const float *widths();
    
    float xAdvancementForGlyph(char aGlyph, char fromAGlyph = '\0');
    float yAdvancementForGlyph(char aGlyph);
    
    float heightOfBoundingRect(char aGlyph = (char)0);
    float widthOfBoundingRect(char aGlyph = (char)0);

    float ascent();
    float descent();
};

#endif // VKFONT_H
