/**
 *
 * $Id: VkMenuBar.h,v 1.2 1995/04/20 05:32:07 toshok Exp $
 *
 * This file contains the class definition for the 
 * VkMenuBar class.  This class allows the user to
 * assign menu bars to VkWindows that make up
 * his/her interface.
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc
 * All Rights Reserved
 *
 **/

#ifndef VKMENUBAR_H
#define VKMENUBAR_H

#include <Xm/RowColumn.h>
#include <Vk/VkConfig.h>
#include <Vk/VkMenu.h>

class VkSubMenu;
class VkWindow;
class VkHelpPane;

class VkMenuBar : public VkMenu {
protected:
  VkHelpPane *_helpPane;
  
public:
  VkMenuBar(Boolean showHelpPane = TRUE);
  VkMenuBar(const char *name,
	    Boolean showHelpPane = TRUE);
  VkMenuBar(VkMenuDesc *menuDesc,
	    XtPointer defaultClientData = NULL,
	    Boolean showHelpPane = TRUE);
  VkMenuBar(const char *name,
	    VkMenuDesc *menuDesc,
	    XtPointer defaultClientData = NULL,
	    Boolean showHelpPane = TRUE);

  virtual ~VkMenuBar();

  VkHelpPane *helpPane() const;

  VkMenuItemType menuType();

  void setLabel(const char *str);

  Boolean isContainer();

  const char *className();
  
  void _instantiate(Widget parent);
};

#endif // VKMENUBAR_H
