/**
 *
 * $Id: VkMenuItem.h,v 1.2 1995/04/20 05:32:07 toshok Exp $
 *
 * This file contains the class definition for VkMenuItem.h
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc
 * All Rights Reserved
 *
 **/

#ifndef VKMENUITEM_H
#define VKMENUITEM_H

#include <Vk/VkConfig.h>
#include <Vk/VkComponent.h>

typedef enum {ACTION, CONFIRMFIRSTACTION, TOGGLE, LABEL, SEPARATOR, SUBMENU,
	      RADIOSUBMENU, BAR, OPTION, POPUP, OBJECT, END} VkMenuItemType;

class VkMenuItem : public VkComponent {
protected:
  Boolean instantiated;
  Boolean activated;
  
public:
  VkMenuItem(char *name);
  
  virtual ~VkMenuItem();
  
  virtual const char *className();
  void show();
  void hide();
  void remove();
  
  void activate();
  void deactivate();
  
  virtual void setLabel(const char *str) = 0;
  
  void setPosition(int position);
  
  virtual VkMenuItemType menuType() = 0;
  virtual Boolean isContainer() = 0;
  
  virtual operator Widget() const;
  virtual void _instantiate(Widget parent);
};

#endif /* VKMENUITEM_H */





