/**
 *
 * $Id: VkPeriodic.h,v 1.2 1995/04/20 05:32:07 toshok Exp $
 *
 * This file contains the class definition for VkPeriodic,
 * which provides a class wrapper for X toolkit time outs.
 *
 * This class isn't publicly documented by SGI (at least, not
 * in the Programmer's Guide), so I had to use to man page to
 * reconstruct it.
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc.
 * All Rights Reserved
 *
 **/

#ifndef VKPERIODIC_H
#define VKPERIODIC_H

#include <X11/Intrinsic.h>
#include <Vk/VkConfig.h>
#include <Vk/VkCallbackObject.h>

class VkPeriodic : public VkCallbackObject {
private:
    int _interval;
    XtIntervalId _id;

    static void tickTimeOut(XtPointer, XtIntervalId *);

protected:
    virtual void tick() { /* empty */};

public:
    VkPeriodic(int interval);

    virtual ~VkPeriodic();

    void start();
    void stop();

    static const char *const timerCallback;
};

#endif // VKPERIODIC_H
