/**
 *
 * $Id: VkPipe.h,v 1.2 1995/04/20 05:32:07 toshok Exp $
 *
 * This file contains the class definition for VkPipe, which
 * provides an interface to unix pipes.
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc
 * All Rights Reserved
 *
 **/

#ifndef VKPIPE_H
#define VKPIPE_H

#include <Vk/VkConfig.h>
#include <Vk/VkCallbackObject.h>
#include <Vk/VkInput.h>

typedef enum {READ, WRITE} End;

class VkPipe : public VkCallbackObject {
protected:
    int pipefd[2];
    VkInput* _input;

    void handleInput(VkCallbackObject *, void *, void *);

public:
    VkPipe(int &fd);

    ~VkPipe();

    int operator[](End whichEnd);

    static const char *const inputCallback;
};

#endif // VKPIPE_H

