/**
 *
 * $Id: VkRepeatButton.h,v 1.2 1995/04/20 05:32:07 toshok Exp $
 *
 * This file contains the class declaration for
 * the VkRepeatButton class, which allows programmers
 * to add buttons that repeatedly call callbacks once
 * armed.
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc.
 * All Rights Reserved
 *
 **/

#ifndef VKREPEATBUTTON_H
#define VKREPEATBUTTON_H

#include <Vk/VkConfig.h>
#include <Vk/VkComponent.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/ArrowB.h>
#include <Xm/ArrowBG.h>

typedef enum {
  RB_pushButton,
  RB_pushButtonGadget,
  RB_arrowButton,
  RB_arrowButtonGadget
} VkRepeatButtonType;

class VkRepeatButton : public VkComponent {
private:
  static String _defaultResources[];
  static const char *const buttonCallback;

  long _initialDelay;
  long _repeatDelay;
  XtIntervalId _repeatId;
  XmAnyCallbackStruct myCallbackInfo;

  VkRepeatButtonType _type;

  static void _beginRepeatCallback(Widget, XtPointer, XtPointer);
  static void _endRepeatCallback(Widget, XtPointer, XtPointer);

  static void _repeatTimeOut(XtPointer, XtIntervalId*);
  
  void _beginRepeat(XtPointer); 
  void _endRepeat();
  void _repeat();

public:
  VkRepeatButton(char *name, Widget parent, VkRepeatButtonType type);  
  
  const char *className();

  void setParameters(long initial, long repeat);

  VkRepeatButtonType type();
};

#endif // VKREPEATBUTTON_H
