/**
 *
 * $Id: VkSubMenu.h,v 1.2 1995/04/20 05:32:07 toshok Exp $
 * 
 * This file contains the class definition for the class VkSubMenu.
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc
 * All Rights Reserved
 *
 **/

#ifndef VKSUBMENU_H
#define VKSUBMENU_H

#include <Vk/VkConfig.h>
#include <Vk/VkMenu.h>
#include <Vk/VkApp.h>
#include <Xm/RowColumn.h>
#include <Xm/CascadeBG.h>

class VkSubMenu : public VkMenu {
  
friend class VkMenuItem;
  
protected:
  Widget _pulldown;
  Boolean _tearOff;
  
public:
  VkSubMenu(const char *name,
	    VkMenuDesc *menuDesc = NULL,
	    XtPointer defaultClientData = NULL);
  
  void showTearOff(Boolean showIt);
  
  Widget pulldown();
  
  VkMenuItemType menuType();

  virtual const char *className();
  
  Boolean isContainer();

  void setLabel(const char *str);

  virtual operator Widget() const;
  
  void _instantiate(Widget parent);

};

#endif // VKSUBMENU_H
