/*****************************************************************
    ViewKlass - C++ framework library for Motif

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Copyright (C) 2001 John Lemcke
    jlemcke@bigfoot.com
*****************************************************************/

/**
 *
 * $Id: VkApp.h,v 1.7 2002/05/20 10:13:35 jostle Exp $
 * This file contains the class definition for the
 * VkApp Application Class.  This class must 
 * be instantiated exactly once in any given application.  
 * Results will be screwy if you don't follow this simple rule.
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc
 * All Rights Reserved
 *
 **/

#ifndef VKAPP_H
#define VKAPP_H

#include <Xm/Xm.h>
#include <Vk/VkConfig.h>
#include <Vk/VkComponent.h>
#include <Vk/VkSimpleWindow.h>
#include <Vk/VkComponentList.h>
#include <Vk/VkCursorList.h>
#include <Vk/VkBusyDialog.h>
#include <Vk/VkInterruptDialog.h>
#include <Vk/VkProgressDialog.h>

typedef enum {Animated, NotAnimated} VkCursorType;

class VkApp : public VkComponent {
	friend class VkSimpleWindow;
public:
    VkApp (char* appClassName,
		   int* argc,
		   char** argv,
		   XrmOptionDescRec* options = NULL,
		   int numOptions = 0);
	// NYI
//      VkApp (char* appClassName,
//  		   int* argc,
//  		   char** argv,
//  		   ArgList argList,
//  		   Cardinal argCount,
//  		   void (*preRealizeFunction)(Widget w),
//  		   XrmOptionDescRec* options = NULL,
//  		   int numOptions = 0);

	virtual ~VkApp();
	
    virtual void run();
	void run(Boolean(*appEventHandler)(XEvent &));
	void runOneEvent(Boolean(*appEventHandler)(XEvent &) = NULL);
	void run_first();
	
    virtual void handleRawEvent(XEvent* event);
    virtual void handlePendingEvents();
	// NYI
//  	XtInputMask handleOnePendingEvent(
//  		Boolean(*appEventHandler)(XEvent &) = NULL);

	virtual void quitYourself();
    virtual void terminate(int status = 0);
  
    void setMainWindow(VkSimpleWindow* window);
    VkSimpleWindow* mainWindow() const;
  
    virtual void show();
    virtual void hide();
    virtual void iconify();
    virtual void open();
    virtual void raise();
    virtual void lower();

    void startupIconified(const Boolean flag);

    void setNormalCursor(Cursor c);
    virtual Cursor normalCursor();
    void setBusyCursor(Cursor c);
    void setBusyCursor(VkCursorList* animatedCursor);
    virtual Cursor busyCursor();
    void showCursor(Cursor c);

    virtual void busy(const char* msg = NULL,
					  VkSimpleWindow* window = NULL);
    virtual void veryBusy(const char* msg = NULL,
						  VkSimpleWindow* window = NULL);
	virtual void progressing(const char* msg = NULL);
	virtual void notBusy();
    void setBusyDialog(VkBusyDialog* dialog);

    void setVersionString(const char* versionInfo);
    const char* versionString();

    void setAboutDialog(VkDialogManager* dialog);
    VkDialogManager* aboutDialog() { return _aboutDialog; };

	// NYI void setStartupDialog(VkDialogManager* dialog);

    // Application Data Access Functions

    char* name() const;
    char* applicationClassName() const;
    virtual const char* className() { return "VkApp"; }
    XtAppContext appContext() const;
    Display* display() const;
    char* shellGeometry() const;
    int argc() const;
    char** argv() const;
    char* argv(int indx) const;
    Boolean startupIconified() const;
	Boolean traceApplication() { return _traceApplication; }

    void registerWindow(VkSimpleWindow* win);
    void unregisterWindow(VkSimpleWindow* win);

  	static void setFallbacks(char **);

    static const char* ViewKlassReleaseString;
    static const int ViewKlassMajorRelease;
    static const int ViewKlassMinorRelease;

	// Help support
	int helpInit(char *client, char *sep);
	struct HelpInitArgs {
		char* client;
		char* sep;
	};
	int helpMsg(char *key, char *book, char *userData);
	struct HelpMsgArgs {
		char* key;
		char* book;
		char* userData;
	};
	int helpIndexMsg(char *key, char *book);
	struct HelpIndexMsgArgs {
		char* key;
		char* book;
	};
	static const char *const helpInitCallback;
	static const char *const helpMsgCallback;
	static const char *const helpIndexMsgCallback;
	// NYI Help support
//  	void useSGIHelp();
//  	static void sgiHelpInit(VkCallbackObject* caller,
//  							void* clientData,
//  							void* callData);
//  	static void sgiHelpMsg(VkCallbackObject* caller,
//  						   void* clientData,
//  						   void* callData);
//  	static void sgiHelpIndexMsg(VkCallbackObject* caller,
//  								void* clientData,
//  								void* callData);

	// Not defined in the man page but needed to implement
	// VkSimpleWindow getWindow(VkComponent*) and
	// VkWindow getWindow(VkComponent*) and getMenu(VkComponent*)
	VkComponentList* winList() { return &_winList; }
	
protected:
    int parseCommandLine(XrmOptionDescRec* options,
						 Cardinal numOptions);

	// NYI
//  	virtual void afterRealizeHook();

    VkComponentList _winList;

private:
    int _applicationArgc;
    char** _applicationArgv;

    XtAppContext _theApp;
    Display* _theDisplay;
    char* _appClassName;
    VkSimpleWindow* _mainWindow;
    char* _versionString;
	
    int _busyDepth;
    Cursor _busyCursor;
    VkBusyDialog* _busyDialog;

    VkDialogManager* _aboutDialog;

	Cursor _currentCursor;
	VkCursorType _cursorType;
    VkCursorList* _busyCursorList;

    Boolean _startupIconified;
    Boolean _dumpResourceFile;
    Boolean _traceApplication;

    static String _defaultResources[];
    static XtResource _resourceList[];

	static char** _fallbacks;
};

extern VkApp* theApplication;

#endif /* VKAPP_H */
