/*****************************************************************
    ViewKlass - C++ framework library for Motif

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Copyright (C) 2001 John Lemcke
    jlemcke@bigfoot.com
*****************************************************************/

/**
 *
 * $Id: builtinbusy.h,v 1.2 2001/09/24 12:53:41 jostle Exp $
 *
 * This file contains the code for the built-in busy cursor,
 * a Big Ben style alarm clock
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc.
 * All Rights Reserved
 *
 **/

#include <Vk/VkApp.h>
#include <Vk/VkResource.h>
#include <Vk/VkCursorList.h>

#define NUMCURSORS 8

static char
#ifdef __GNUC__
__attribute__ ((unused))
#endif
clock_bits[NUMCURSORS*2][27*30] = {
  {
  0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x0e, 0x00, 0x30, 0x02, 0x31, 0x00,
  0x08, 0x84, 0x40, 0x00, 0x04, 0x02, 0x81, 0x00, 0x04, 0x01, 0x82, 0x00,
  0xc4, 0xff, 0x8f, 0x00, 0xa4, 0x03, 0x97, 0x00, 0xd8, 0x00, 0x6c, 0x00,
  0x20, 0x00, 0x10, 0x00, 0x10, 0x00, 0x20, 0x00, 0x10, 0x00, 0x20, 0x00,
  0x08, 0x00, 0x40, 0x00, 0x08, 0x00, 0x40, 0x00, 0x04, 0x00, 0x80, 0x00,
  0x04, 0x00, 0x80, 0x00, 0x04, 0x00, 0x80, 0x00, 0x04, 0xf0, 0x9f, 0x00,
  0x04, 0x00, 0x80, 0x00, 0x04, 0x00, 0x80, 0x00, 0x04, 0x00, 0x80, 0x00,
  0x08, 0x00, 0x40, 0x00, 0x08, 0x00, 0x40, 0x00, 0x10, 0x00, 0x20, 0x00,
  0x10, 0x00, 0x20, 0x00, 0x30, 0x00, 0x30, 0x00, 0xf8, 0x00, 0x7c, 0x00,
  0x1c, 0x03, 0xe3, 0x00, 0x0c, 0xfc, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
  },
  {
  0xff, 0xff, 0xff, 0x07, 0x3f, 0xfe, 0xf1, 0x07, 0xcf, 0xfd, 0xce, 0x07,
  0xf7, 0x7b, 0xbf, 0x07, 0xfb, 0xfd, 0x7e, 0x07, 0xfb, 0xfe, 0x7d, 0x07,
  0x3b, 0x00, 0x70, 0x07, 0x5b, 0xfc, 0x68, 0x07, 0x27, 0xff, 0x93, 0x07,
  0xdf, 0xff, 0xef, 0x07, 0xef, 0xff, 0xdf, 0x07, 0xef, 0xff, 0xdf, 0x07,
  0xf7, 0xff, 0xbf, 0x07, 0xf7, 0xff, 0xbf, 0x07, 0xfb, 0xff, 0x7f, 0x07,
  0xfb, 0xff, 0x7f, 0x07, 0xfb, 0xff, 0x7f, 0x07, 0xfb, 0x0f, 0x60, 0x07,
  0xfb, 0xff, 0x7f, 0x07, 0xfb, 0xff, 0x7f, 0x07, 0xfb, 0xff, 0x7f, 0x07,
  0xf7, 0xff, 0xbf, 0x07, 0xf7, 0xff, 0xbf, 0x07, 0xef, 0xff, 0xdf, 0x07,
  0xef, 0xff, 0xdf, 0x07, 0xcf, 0xff, 0xcf, 0x07, 0x07, 0xff, 0x83, 0x07,
  0xe3, 0xfc, 0x1c, 0x07, 0xf3, 0x03, 0x3f, 0x07, 0xff, 0xff, 0xff, 0x07,
  },
  {
  0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x0e, 0x00, 0x30, 0x02, 0x31, 0x00,
  0x08, 0x84, 0x40, 0x00, 0x04, 0x02, 0x81, 0x00, 0x04, 0x01, 0x82, 0x00,
  0xc4, 0xff, 0x8f, 0x00, 0xa4, 0x03, 0x97, 0x00, 0xd8, 0x00, 0x6c, 0x00,
  0x20, 0x00, 0x10, 0x00, 0x10, 0x00, 0x20, 0x00, 0x10, 0x00, 0x20, 0x00,
  0x08, 0x00, 0x44, 0x00, 0x08, 0x00, 0x42, 0x00, 0x04, 0x80, 0x81, 0x00,
  0x04, 0x40, 0x80, 0x00, 0x04, 0x20, 0x80, 0x00, 0x04, 0x10, 0x80, 0x00,
  0x04, 0x00, 0x80, 0x00, 0x04, 0x00, 0x80, 0x00, 0x04, 0x00, 0x80, 0x00,
  0x08, 0x00, 0x40, 0x00, 0x08, 0x00, 0x40, 0x00, 0x10, 0x00, 0x20, 0x00,
  0x10, 0x00, 0x20, 0x00, 0x30, 0x00, 0x30, 0x00, 0xf8, 0x00, 0x7c, 0x00,
  0x1c, 0x03, 0xe3, 0x00, 0x0c, 0xfc, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
  },
  {
  0xff, 0xff, 0xff, 0x07, 0x3f, 0xfe, 0xf1, 0x07, 0xcf, 0xfd, 0xce, 0x07,
  0xf7, 0x7b, 0xbf, 0x07, 0xfb, 0xfd, 0x7e, 0x07, 0xfb, 0xfe, 0x7d, 0x07,
  0x3b, 0x00, 0x70, 0x07, 0x5b, 0xfc, 0x68, 0x07, 0x27, 0xff, 0x93, 0x07,
  0xdf, 0xff, 0xef, 0x07, 0xef, 0xff, 0xdf, 0x07, 0xef, 0xff, 0xdf, 0x07,
  0xf7, 0xff, 0xbb, 0x07, 0xf7, 0xff, 0xbd, 0x07, 0xfb, 0x7f, 0x7e, 0x07,
  0xfb, 0xbf, 0x7f, 0x07, 0xfb, 0xdf, 0x7f, 0x07, 0xfb, 0xef, 0x7f, 0x07,
  0xfb, 0xff, 0x7f, 0x07, 0xfb, 0xff, 0x7f, 0x07, 0xfb, 0xff, 0x7f, 0x07,
  0xf7, 0xff, 0xbf, 0x07, 0xf7, 0xff, 0xbf, 0x07, 0xef, 0xff, 0xdf, 0x07,
  0xef, 0xff, 0xdf, 0x07, 0xcf, 0xff, 0xcf, 0x07, 0x07, 0xff, 0x83, 0x07,
  0xe3, 0xfc, 0x1c, 0x07, 0xf3, 0x03, 0x3f, 0x07, 0xff, 0xff, 0xff, 0x07,
  },
  {
  0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x0e, 0x00, 0x30, 0x02, 0x31, 0x00,
  0x08, 0x84, 0x40, 0x00, 0x04, 0x02, 0x81, 0x00, 0x04, 0x01, 0x82, 0x00,
  0xc4, 0xff, 0x8f, 0x00, 0xa4, 0x03, 0x97, 0x00, 0xd8, 0x00, 0x6c, 0x00,
  0x20, 0x10, 0x10, 0x00, 0x10, 0x10, 0x20, 0x00, 0x10, 0x10, 0x20, 0x00,
  0x08, 0x10, 0x40, 0x00, 0x08, 0x10, 0x40, 0x00, 0x04, 0x10, 0x80, 0x00,
  0x04, 0x10, 0x80, 0x00, 0x04, 0x10, 0x80, 0x00, 0x04, 0x10, 0x80, 0x00,
  0x04, 0x00, 0x80, 0x00, 0x04, 0x00, 0x80, 0x00, 0x04, 0x00, 0x80, 0x00,
  0x08, 0x00, 0x40, 0x00, 0x08, 0x00, 0x40, 0x00, 0x10, 0x00, 0x20, 0x00,
  0x10, 0x00, 0x20, 0x00, 0x30, 0x00, 0x30, 0x00, 0xf8, 0x00, 0x7c, 0x00,
  0x1c, 0x03, 0xe3, 0x00, 0x0c, 0xfc, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
  },
  {
  0xff, 0xff, 0xff, 0x07, 0x3f, 0xfe, 0xf1, 0x07, 0xcf, 0xfd, 0xce, 0x07,
  0xf7, 0x7b, 0xbf, 0x07, 0xfb, 0xfd, 0x7e, 0x07, 0xfb, 0xfe, 0x7d, 0x07,
  0x3b, 0x00, 0x70, 0x07, 0x5b, 0xfc, 0x68, 0x07, 0x27, 0xff, 0x93, 0x07,
  0xdf, 0xef, 0xef, 0x07, 0xef, 0xef, 0xdf, 0x07, 0xef, 0xef, 0xdf, 0x07,
  0xf7, 0xef, 0xbf, 0x07, 0xf7, 0xef, 0xbf, 0x07, 0xfb, 0xef, 0x7f, 0x07,
  0xfb, 0xef, 0x7f, 0x07, 0xfb, 0xef, 0x7f, 0x07, 0xfb, 0xef, 0x7f, 0x07,
  0xfb, 0xff, 0x7f, 0x07, 0xfb, 0xff, 0x7f, 0x07, 0xfb, 0xff, 0x7f, 0x07,
  0xf7, 0xff, 0xbf, 0x07, 0xf7, 0xff, 0xbf, 0x07, 0xef, 0xff, 0xdf, 0x07,
  0xef, 0xff, 0xdf, 0x07, 0xcf, 0xff, 0xcf, 0x07, 0x07, 0xff, 0x83, 0x07,
  0xe3, 0xfc, 0x1c, 0x07, 0xf3, 0x03, 0x3f, 0x07, 0xff, 0xff, 0xff, 0x07,
  },
  {
  0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x0e, 0x00, 0x30, 0x02, 0x31, 0x00,
  0x08, 0x84, 0x40, 0x00, 0x04, 0x02, 0x81, 0x00, 0x04, 0x01, 0x82, 0x00,
  0xc4, 0xff, 0x8f, 0x00, 0xa4, 0x03, 0x97, 0x00, 0xd8, 0x00, 0x6c, 0x00,
  0x20, 0x00, 0x10, 0x00, 0x10, 0x00, 0x20, 0x00, 0x10, 0x00, 0x20, 0x00,
  0x88, 0x00, 0x40, 0x00, 0x08, 0x01, 0x40, 0x00, 0x04, 0x02, 0x80, 0x00,
  0x04, 0x04, 0x80, 0x00, 0x04, 0x08, 0x80, 0x00, 0x04, 0x10, 0x80, 0x00,
  0x04, 0x00, 0x80, 0x00, 0x04, 0x00, 0x80, 0x00, 0x04, 0x00, 0x80, 0x00,
  0x08, 0x00, 0x40, 0x00, 0x08, 0x00, 0x40, 0x00, 0x10, 0x00, 0x20, 0x00,
  0x10, 0x00, 0x20, 0x00, 0x30, 0x00, 0x30, 0x00, 0xf8, 0x00, 0x7c, 0x00,
  0x1c, 0x03, 0xe3, 0x00, 0x0c, 0xfc, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
  },
  {
  0xff, 0xff, 0xff, 0x07, 0x3f, 0xfe, 0xf1, 0x07, 0xcf, 0xfd, 0xce, 0x07,
  0xf7, 0x7b, 0xbf, 0x07, 0xfb, 0xfd, 0x7e, 0x07, 0xfb, 0xfe, 0x7d, 0x07,
  0x3b, 0x00, 0x70, 0x07, 0x5b, 0xfc, 0x68, 0x07, 0x27, 0xff, 0x93, 0x07,
  0xdf, 0xff, 0xef, 0x07, 0xef, 0xff, 0xdf, 0x07, 0xef, 0xff, 0xdf, 0x07,
  0x77, 0xff, 0xbf, 0x07, 0xf7, 0xfe, 0xbf, 0x07, 0xfb, 0xfd, 0x7f, 0x07,
  0xfb, 0xfb, 0x7f, 0x07, 0xfb, 0xf7, 0x7f, 0x07, 0xfb, 0xef, 0x7f, 0x07,
  0xfb, 0xff, 0x7f, 0x07, 0xfb, 0xff, 0x7f, 0x07, 0xfb, 0xff, 0x7f, 0x07,
  0xf7, 0xff, 0xbf, 0x07, 0xf7, 0xff, 0xbf, 0x07, 0xef, 0xff, 0xdf, 0x07,
  0xef, 0xff, 0xdf, 0x07, 0xcf, 0xff, 0xcf, 0x07, 0x07, 0xff, 0x83, 0x07,
  0xe3, 0xfc, 0x1c, 0x07, 0xf3, 0x03, 0x3f, 0x07, 0xff, 0xff, 0xff, 0x07,
  },
  {
  0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x0e, 0x00, 0x30, 0x02, 0x31, 0x00,
  0x08, 0x84, 0x40, 0x00, 0x04, 0x02, 0x81, 0x00, 0x04, 0x01, 0x82, 0x00,
  0xc4, 0xff, 0x8f, 0x00, 0xa4, 0x03, 0x97, 0x00, 0xd8, 0x00, 0x6c, 0x00,
  0x20, 0x00, 0x10, 0x00, 0x10, 0x00, 0x20, 0x00, 0x10, 0x00, 0x20, 0x00,
  0x08, 0x00, 0x40, 0x00, 0x08, 0x00, 0x40, 0x00, 0x04, 0x00, 0x80, 0x00,
  0x04, 0x00, 0x80, 0x00, 0x04, 0x00, 0x80, 0x00, 0xe4, 0x1f, 0x80, 0x00,
  0x04, 0x00, 0x80, 0x00, 0x04, 0x00, 0x80, 0x00, 0x04, 0x00, 0x80, 0x00,
  0x08, 0x00, 0x40, 0x00, 0x08, 0x00, 0x40, 0x00, 0x10, 0x00, 0x20, 0x00,
  0x10, 0x00, 0x20, 0x00, 0x30, 0x00, 0x30, 0x00, 0xf8, 0x00, 0x7c, 0x00,
  0x1c, 0x03, 0xe3, 0x00, 0x0c, 0xfc, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
  },
  {
  0xff, 0xff, 0xff, 0x07, 0x3f, 0xfe, 0xf1, 0x07, 0xcf, 0xfd, 0xce, 0x07,
  0xf7, 0x7b, 0xbf, 0x07, 0xfb, 0xfd, 0x7e, 0x07, 0xfb, 0xfe, 0x7d, 0x07,
  0x3b, 0x00, 0x70, 0x07, 0x5b, 0xfc, 0x68, 0x07, 0x27, 0xff, 0x93, 0x07,
  0xdf, 0xff, 0xef, 0x07, 0xef, 0xff, 0xdf, 0x07, 0xef, 0xff, 0xdf, 0x07,
  0xf7, 0xff, 0xbf, 0x07, 0xf7, 0xff, 0xbf, 0x07, 0xfb, 0xff, 0x7f, 0x07,
  0xfb, 0xff, 0x7f, 0x07, 0xfb, 0xff, 0x7f, 0x07, 0x1b, 0xe0, 0x7f, 0x07,
  0xfb, 0xff, 0x7f, 0x07, 0xfb, 0xff, 0x7f, 0x07, 0xfb, 0xff, 0x7f, 0x07,
  0xf7, 0xff, 0xbf, 0x07, 0xf7, 0xff, 0xbf, 0x07, 0xef, 0xff, 0xdf, 0x07,
  0xef, 0xff, 0xdf, 0x07, 0xcf, 0xff, 0xcf, 0x07, 0x07, 0xff, 0x83, 0x07,
  0xe3, 0xfc, 0x1c, 0x07, 0xf3, 0x03, 0x3f, 0x07, 0xff, 0xff, 0xff, 0x07,
  },
  {
  0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x0e, 0x00, 0x30, 0x02, 0x31, 0x00,
  0x08, 0x84, 0x40, 0x00, 0x04, 0x02, 0x81, 0x00, 0x04, 0x01, 0x82, 0x00,
  0xc4, 0xff, 0x8f, 0x00, 0xa4, 0x03, 0x97, 0x00, 0xd8, 0x00, 0x6c, 0x00,
  0x20, 0x00, 0x10, 0x00, 0x10, 0x00, 0x20, 0x00, 0x10, 0x00, 0x20, 0x00,
  0x08, 0x00, 0x40, 0x00, 0x08, 0x00, 0x40, 0x00, 0x04, 0x00, 0x80, 0x00,
  0x04, 0x00, 0x80, 0x00, 0x04, 0x00, 0x80, 0x00, 0x04, 0x10, 0x80, 0x00,
  0x04, 0x08, 0x80, 0x00, 0x04, 0x04, 0x80, 0x00, 0x04, 0x02, 0x80, 0x00,
  0x08, 0x01, 0x40, 0x00, 0x88, 0x00, 0x40, 0x00, 0x10, 0x00, 0x20, 0x00,
  0x10, 0x00, 0x20, 0x00, 0x30, 0x00, 0x30, 0x00, 0xf8, 0x00, 0x7c, 0x00,
  0x1c, 0x03, 0xe3, 0x00, 0x0c, 0xfc, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
  },
  {
  0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x0e, 0x00, 0x30, 0x02, 0x31, 0x00,
  0x08, 0x84, 0x40, 0x00, 0x04, 0x02, 0x81, 0x00, 0x04, 0x01, 0x82, 0x00,
  0xc4, 0xff, 0x8f, 0x00, 0xa4, 0x03, 0x97, 0x00, 0xd8, 0x00, 0x6c, 0x00,
  0x20, 0x00, 0x10, 0x00, 0x10, 0x00, 0x20, 0x00, 0x10, 0x00, 0x20, 0x00,
  0x08, 0x00, 0x40, 0x00, 0x08, 0x00, 0x40, 0x00, 0x04, 0x00, 0x80, 0x00,
  0x04, 0x00, 0x80, 0x00, 0x04, 0x00, 0x80, 0x00, 0x04, 0x10, 0x80, 0x00,
  0x04, 0x10, 0x80, 0x00, 0x04, 0x10, 0x80, 0x00, 0x04, 0x10, 0x80, 0x00,
  0x08, 0x10, 0x40, 0x00, 0x08, 0x10, 0x40, 0x00, 0x10, 0x10, 0x20, 0x00,
  0x10, 0x10, 0x20, 0x00, 0x30, 0x10, 0x30, 0x00, 0xf8, 0x00, 0x7c, 0x00,
  0x1c, 0x03, 0xe3, 0x00, 0x0c, 0xfc, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
  },
  {
  0xff, 0xff, 0xff, 0x07, 0x3f, 0xfe, 0xf1, 0x07, 0xcf, 0xfd, 0xce, 0x07,
  0xf7, 0x7b, 0xbf, 0x07, 0xfb, 0xfd, 0x7e, 0x07, 0xfb, 0xfe, 0x7d, 0x07,
  0x3b, 0x00, 0x70, 0x07, 0x5b, 0xfc, 0x68, 0x07, 0x27, 0xff, 0x93, 0x07,
  0xdf, 0xff, 0xef, 0x07, 0xef, 0xff, 0xdf, 0x07, 0xef, 0xff, 0xdf, 0x07,
  0xf7, 0xff, 0xbf, 0x07, 0xf7, 0xff, 0xbf, 0x07, 0xfb, 0xff, 0x7f, 0x07,
  0xfb, 0xff, 0x7f, 0x07, 0xfb, 0xff, 0x7f, 0x07, 0xfb, 0xef, 0x7f, 0x07,
  0xfb, 0xef, 0x7f, 0x07, 0xfb, 0xef, 0x7f, 0x07, 0xfb, 0xef, 0x7f, 0x07,
  0xf7, 0xef, 0xbf, 0x07, 0xf7, 0xef, 0xbf, 0x07, 0xef, 0xef, 0xdf, 0x07,
  0xef, 0xef, 0xdf, 0x07, 0xcf, 0xef, 0xcf, 0x07, 0x07, 0xff, 0x83, 0x07,
  0xe3, 0xfc, 0x1c, 0x07, 0xf3, 0x03, 0x3f, 0x07, 0xff, 0xff, 0xff, 0x07,
  },
  {
  0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x0e, 0x00, 0x30, 0x02, 0x31, 0x00,
  0x08, 0x84, 0x40, 0x00, 0x04, 0x02, 0x81, 0x00, 0x04, 0x01, 0x82, 0x00,
  0xc4, 0xff, 0x8f, 0x00, 0xa4, 0x03, 0x97, 0x00, 0xd8, 0x00, 0x6c, 0x00,
  0x20, 0x00, 0x10, 0x00, 0x10, 0x00, 0x20, 0x00, 0x10, 0x00, 0x20, 0x00,
  0x08, 0x00, 0x40, 0x00, 0x08, 0x00, 0x40, 0x00, 0x04, 0x00, 0x80, 0x00,
  0x04, 0x00, 0x80, 0x00, 0x04, 0x00, 0x80, 0x00, 0x04, 0x10, 0x80, 0x00,
  0x04, 0x20, 0x80, 0x00, 0x04, 0x40, 0x80, 0x00, 0x04, 0x80, 0x80, 0x00,
  0x08, 0x00, 0x41, 0x00, 0x08, 0x00, 0x42, 0x00, 0x10, 0x00, 0x20, 0x00,
  0x10, 0x00, 0x20, 0x00, 0x30, 0x00, 0x30, 0x00, 0xf8, 0x00, 0x7c, 0x00,
  0x1c, 0x03, 0xe3, 0x00, 0x0c, 0xfc, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
  },
  {
  0xff, 0xff, 0xff, 0x07, 0x3f, 0xfe, 0xf1, 0x07, 0xcf, 0xfd, 0xce, 0x07,
  0xf7, 0x7b, 0xbf, 0x07, 0xfb, 0xfd, 0x7e, 0x07, 0xfb, 0xfe, 0x7d, 0x07,
  0x3b, 0x00, 0x70, 0x07, 0x5b, 0xfc, 0x68, 0x07, 0x27, 0xff, 0x93, 0x07,
  0xdf, 0xff, 0xef, 0x07, 0xef, 0xff, 0xdf, 0x07, 0xef, 0xff, 0xdf, 0x07,
  0xf7, 0xff, 0xbf, 0x07, 0xf7, 0xff, 0xbf, 0x07, 0xfb, 0xff, 0x7f, 0x07,
  0xfb, 0xff, 0x7f, 0x07, 0xfb, 0xff, 0x7f, 0x07, 0xfb, 0xef, 0x7f, 0x07,
  0xfb, 0xdf, 0x7f, 0x07, 0xfb, 0xbf, 0x7f, 0x07, 0xfb, 0x7f, 0x7f, 0x07,
  0xf7, 0xff, 0xbe, 0x07, 0xf7, 0xff, 0xbd, 0x07, 0xef, 0xff, 0xdf, 0x07,
  0xef, 0xff, 0xdf, 0x07, 0xcf, 0xff, 0xcf, 0x07, 0x07, 0xff, 0x83, 0x07,
  0xe3, 0xfc, 0x1c, 0x07, 0xf3, 0x03, 0x3f, 0x07, 0xff, 0xff, 0xff, 0x07,
  }
};

class BuiltInBusyCursor : public VkCursorList {
private:
  XColor xcolors[2];

protected:
  void createCursor(int indx);

public:
  BuiltInBusyCursor();
};


