#ifndef INCL_XCLASSESCLASS_H
#define INCL_XCLASSESCLASS_H

/*-----------------------------------------------------------------------
 * Xclasses header file
 * 
 * Copyright (C) 1998 Jrgen Schmitz
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *-----------------------------------------------------------------------
 */

#include <Xclasses/callable.h>
#include <Xclasses/types.h>

class Xclasses : public callable
{
	friend class pXclasses;
	class pXclasses *p;
public:
	void *classdata;	// free for your own use

    Xclasses();
    Xclasses(char *name);
    virtual ~Xclasses();

	void Name(char *n);
	char *Name(void);
	char *FullName(void);
	void ParentClass(Xclasses *);
	void ParentClass(Xclasses &o) { ParentClass(&o); };
	Xclasses *ParentClass(void);
	int IsClassType(char *);
	Xclasses *ParentClassType(char *);

	char *GetResource(char *);
	void SetResource(char *,char *);

	static Xclasses *ScanObjects(char *basename,Xclasses *old);
};

class Xclasses *FindObject(char *name);
class Xclasses *FindObject(char *base,char *name);
inline class Xclasses *FindObject(class Xclasses *base,char *name)
{ return FindObject(base->FullName(),name); }
void DeleteObjectTree(char *base,int flags=0);
char *TranslateName(char *name);		// manipulates (name)!

#define DOT_NOTBASE		0x00000001	// don't delete named base object

#endif
