#ifndef INCL_DIRVIEW_H
#define INCL_DIRVIEW_H

/*-----------------------------------------------------------------------
 * Xclasses header file
 * 
 * Copyright (C) 1998 Jrgen Schmitz
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *-----------------------------------------------------------------------
 */

#include <Xclasses/types.h>
#include <Xclasses/gadget.h>
#include <Xclasses/listview.h>
#include <Xclasses/input.h>

class dirview : public multilistview
{
	friend class pdirview;

	class pdirview *p;

public:
	virtual void GExpose(XEvent *);
    virtual int  GActivate(XEvent *event,int why);
    virtual int  GSelected(XEvent *event,int why,int wasabove);

public:
    dirview();
    dirview(char *dir);
    virtual ~dirview();

    virtual int Create(void);
    virtual void Free(void);

	void ApplyInput(input *);
	void ApplyInput(input &);

	int  SetDir(char *);
	void RereadDir(void);
	void GetDir(char *,int size);
	void GetFile(char *,int size);
	void SetPattern(char *);
	void ShowPeriod(void);
	void NoPeriod(void);
	void DirsFirst(void);
	void DirsNormal(void);
	void DirsOnly(void);
	void FilesOnly(void);
	void DirsFiles(void);

	void DirSelector(void);
	void FileSelector(void);

	int IsSelectedMarked(void);
	int FindNextMarked(int,char *,int size);
};

#endif
