#ifndef INCL_KEYCLASS_H
#define INCL_KEYCLASS_H

/*-----------------------------------------------------------------------
 * Xclasses header file
 * 
 * Copyright (C) 1998 Jrgen Schmitz
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *-----------------------------------------------------------------------
 */

#include <Xclasses/types.h>
#include <Xclasses/Xwindows.h>
#include <Xclasses/gadget.h>
#include <Xclasses/callable.h>
#include <X11/keysym.h>
#include <X11/keysymdef.h>

#define KEY_NONE	0
#define KEY_SHIFT	1
#define KEY_CONTROL	2
#define KEY_ALT		4

class keyclass : public Xclasses
{
	friend class pkeyclass;

	class pkeyclass *p;
public:
    keyclass(class Xwindows *);
    virtual ~keyclass(void);

	void operator=(keyclass *);
	void operator=(keyclass &); // e.g. *x1=*x2!!!

	void FreeKey(unsigned int xkey,unsigned int qual);
	void FreeKey(char *key,unsigned int qual);	

	void SendActivateTo(unsigned int xkey,unsigned int qual,gadget *);
	void SendActivateTo(unsigned int xkey,unsigned int qual,gadget &g) { SendActivateTo(xkey,qual,&g); }
	void SendActivateTo(char *key,unsigned int qual,gadget *);
	void SendActivateTo(char *key,unsigned int qual,gadget &g) { SendActivateTo(key,qual,&g); }
	
	void SendSelectTo(unsigned int xkey,unsigned int qual,gadget *);
	void SendSelectTo(unsigned int xkey,unsigned int qual,gadget &g) { SendSelectTo(xkey,qual,&g); }
	void SendSelectTo(char *key,unsigned int qual,gadget *);
	void SendSelectTo(char *key,unsigned int qual,gadget &g) { SendSelectTo(key,qual,&g); }

	void SendKeyTo(unsigned int xkey,unsigned int qual,gadget *);
	void SendKeyTo(unsigned int xkey,unsigned int qual,gadget &g) { SendKeyTo(xkey,qual,&g); }
	void SendKeyTo(char *key,unsigned int qual,gadget *);
	void SendKeyTo(char *key,unsigned int qual,gadget &g) { SendKeyTo(key,qual,&g); }

	void SendHookTo(unsigned int xkey,unsigned int qual,void (*h)(XEvent *,KeySym,char *,int),int userdata=0);
	void SendHookTo(char *key,unsigned int qual,void (*h)(XEvent *,KeySym,char *,int),int userdata=0);
	void SendHookTo(unsigned int xkey,unsigned int qual,callable *hclass,void (callable::*h)(XEvent *,KeySym,char *,int),int userdata=0);
	void SendHookTo(char *key,unsigned int qual,callable *hclass,void (callable::*h)(XEvent *,KeySym,char *,int),int userdata=0);

// Hook is: int h(XEvent *,KeySym,char *,int) !
	void SendHookSelectTo(unsigned int xkey,unsigned int qual,gadget *,void (*h)(XEvent *,KeySym,char *,int),int userdata=0);
	void SendHookSelectTo(unsigned int xkey,unsigned int qual,gadget &,void (*h)(XEvent *,KeySym,char *,int),int userdata=0);
	void SendHookSelectTo(char *key,unsigned int qual,gadget *,void (*h)(XEvent *,KeySym,char *,int),int userdata=0);
	void SendHookSelectTo(char *key,unsigned int qual,gadget &,void (*h)(XEvent *,KeySym,char *,int),int userdata=0);
	void SendHookSelectTo(unsigned int xkey,unsigned int qual,gadget *,callable *hclass,void (callable::*h)(XEvent *,KeySym,char *,int),int userdata=0);
	void SendHookSelectTo(unsigned int xkey,unsigned int qual,gadget &,callable *hclass,void (callable::*h)(XEvent *,KeySym,char *,int),int userdata=0);
	void SendHookSelectTo(char *key,unsigned int qual,gadget *,callable *hclass,void (callable::*h)(XEvent *,KeySym,char *,int),int userdata=0);
	void SendHookSelectTo(char *key,unsigned int qual,gadget &,callable *hclass,void (callable::*h)(XEvent *,KeySym,char *,int),int userdata=0);
};

#define SENDHOOK void (callable::*)(XEvent *,KeySym,char *,int)

#endif
