#ifndef INCL_INPUT_H
#define INCL_INPUT_H

/*-----------------------------------------------------------------------
 * Xclasses header file
 * 
 * Copyright (C) 1998 Jrgen Schmitz
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *-----------------------------------------------------------------------
 */

#include <Xclasses/types.h>
#include <Xclasses/gadget.h>
#include <Xclasses/Xcolors.h>
#include <Xclasses/Ddraw.h>

class input : public gadget, private Ddraw
{
	friend class pinput;

	class pinput *p;

public:
    virtual void GExpose(XEvent *event);
    virtual void GActionPress(int mx,int my,int rx,int ry,unsigned int state,int button,int reason);
    virtual void GActionRelease(int mx,int my,int rx,int ry,unsigned int state,int button,int reason);
    virtual int  GMouseMove(int mx,int my,int rx,int ry,unsigned int state,int button);
    virtual int  GActivate(XEvent *event,int why);
    virtual int  GSelected(XEvent *event,int why,int wasabove);
	virtual int  GClipHandler(int why,char *data,int size);
	virtual void GSetLimits(void);

public:
    input();
    virtual ~input();

    virtual int Create(void);
    virtual void Free(void);
	virtual void Resize(int w,int h);
	virtual void Lock(void);
	virtual void Unlock(void);
	virtual void Block(int);
	virtual void Unblock(int);

    int MaxChars(int m);
    void Text(char *t);
    void AlwaysMode(void);
	void IntegerMode(void);
	void InvisibleMode(void);

    void Default(char *t);
	void Input(char *t);
	void Cursor(int c);
	int Cursor(void);
	void MarkTo(int);
	int MarkSize(void);
	void MarkedText(char *);
	void ReplaceMarkedText(char *);
};

#endif
