#ifndef INCL_POPUP_H
#define INCL_POPUP_H

/*-----------------------------------------------------------------------
 * Xclasses header file
 * 
 * Copyright (C) 1998 Jrgen Schmitz
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *-----------------------------------------------------------------------
 */

#include <Xclasses/types.h>
#include <Xclasses/Ddraw.h>
#include <Xclasses/Xcolors.h>
#include <Xclasses/gadget.h>
#include <Xclasses/callable.h>

class popup : public gadget, private Ddraw
{
	friend class ppopup;
	
	class ppopup *p;

public:
    virtual void GExpose(XEvent *event);
    virtual void GActionPress(int mx,int my,int rx,int ry,unsigned int state,int button,int reason);
    virtual void GActionRelease(int mx,int my,int rx,int ry,unsigned int state,int button,int reason);
	virtual void GSetLimits(void);
	virtual int GActivate(XEvent *event,int why);
	virtual int GSelected(XEvent *event,int why,int wasabove);
    virtual int GMouseMove(int mx,int my,int rx,int ry,unsigned int state,int button);

    popup();
    virtual ~popup();

	int Create();
	void Free(void);

	void KeyHook(int hook(popup *,int),int);
	void KeyHook(callable *hc,int (callable::*hook)(popup *,int),int userdata);
// opens after create or any times later
	virtual void Open(int w=0);
	virtual void Open(int x,int y,int w=0);
	virtual void OpenAt(int x,int y,int atsel,int w=0);
	virtual void Close(void);
	
	virtual int PopupOpen(void);	// 0 - no, 1 - yes
	
	void Resize(int w,int h);
	void Lock(void);
	void Unlock(void);
    void Block(int);
    void Unblock(int);

	virtual void LockItem(int pid);
	virtual void UnlockItem(int pid);
	virtual void LockHeadOf(int pid);
	virtual void UnlockHeadOf(int pid);

	virtual void State(int pid,int state);
	virtual int State(int pid);

	virtual void Selected(int pid,int s);
	virtual int Selected(int pid);

	void Add(char *text,char *scut,int pid);
	void AddRuler(void);
	void AddHeadline(char *);
	void AddSel(char *text,char *scut,int pid);
	void AddMX(char **text,char **scut,int pid);
	void AddSub(char *text);
	void EndSub(void);
	void Clear(void);

	virtual int PID();
};

#define KEYHOOK   int (callable::*)(popup *,int)

#endif
