/*@
 * Copyright(c) 1995-1997 Gregory M. Messner
 * All rights reserved
 *
 * Permission to use, copy, modify and distribute this material for
 * non-commercial personal and educational use without fee is hereby
 * granted, provided that the above copyright notice and this permission 
 * notice appear in all copies, and that the name of Gregory M. Messner
 * not be used in advertising or publicity pertaining to this material
 * without the specific, prior written permission of Gregory M. Messner 
 * or an authorized representative.
 *
 * GREGORY M. MESSNER MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, 
 * EXPRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST INFRINGEMENT OF PATENTS
 * OR OTHER INTELLECTUAL PROPERTY RIGHTS. THE SOFTWARE IS PROVIDED "AS IS",
 * AND IN NO EVENT SHALL GREGORY M. MESSNER BE LIABLE FOR ANY DAMAGES,
 * INCLUDING ANY LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES
 * RELATING TO THE SOFTWARE.
 *
 */


#include	<stdio.h>

#include	<Xm/Xm.h>
#include	"ExtPushB.h"
#include	"Row.h"

#include 	"CancelPB.xpm"
#include	"HandSign.xpm"
#include	"HelpPB.xpm"
#include	"NoPB.xpm"
#include	"OkayPB.xpm"
#include	"YesPB.xpm"

static void
callback(w, parent)
Widget w, parent;
{
Widget button;
static int switcher = 0, count = 0;

	switcher++;
	if ( switcher == 4 )
		switcher = 0;
		

	if ( switcher < 2 )
	{
		printf("creating new one, count=%d\n", ++count);
		XtDestroyWidget(w);

	    w = XtVaCreateManagedWidget(NULL, 
		xgExtPushButtonWidgetClass, parent,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_FORM,
		XgNshift, True,
		XgNextLabelType, XgPIXMAP_FILE,
		XgNextPixmap, (switcher == 0) ? "OkayPB.xpm" : "CancelPB.xpm",
		XtVaTypedArg, XmNarmColor, XmRString, "pink", 5,
		NULL);

	    XtAddCallback(w, XmNactivateCallback, callback, parent);

	}
	else
	{
		printf("switching pixmap, count=%d\n", ++count);
		XtVaSetValues(w, XgNextPixmap, 
			(switcher % 2) ? "OkayPB.xpm" : "CancelPB.xpm", NULL);
	}
	
}


main(argc, argv)
int	argc;
char	**argv;
{	
Widget	 	topLevel;
Widget		form;	
Widget		button;
XtAppContext	app;
int		i;




	topLevel = XtVaAppInitialize(&app,
		"Test",
		NULL, 0,
		&argc, argv,
		NULL,
		NULL);

	form = XtVaCreateManagedWidget(NULL, 
		xgRowWidgetClass, topLevel, 
		XgNalignChildren, XgALIGN_TOP_LEFT,
		XmNorientation, XmVERTICAL, NULL);

	button = XtVaCreateManagedWidget(NULL, 
		xgExtPushButtonWidgetClass, form,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_FORM,
		XgNshift, True,
		XgNextLabelType, XgPIXMAP_FILE,
		XgNextPixmap, "YesPB.xpm",
		XtVaTypedArg, XmNarmColor, XmRString, "pink", 5,
		NULL);

	button = XtVaCreateManagedWidget(NULL, 
		xgExtPushButtonWidgetClass, form,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_FORM,
		XgNshift, True,
		XgNextLabelType, XgPIXMAP_FILE,
		XgNextPixmap, "NoPB.xpm",
		XtVaTypedArg, XmNarmColor, XmRString, "pink", 5,
		NULL);



	button = XtVaCreateManagedWidget(NULL, 
		xgExtPushButtonWidgetClass, form,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_FORM,
		XgNshift, True,
		XgNextLabelType, XgPIXMAP_DATA,
		XgNextPixmap, YesPB_xpm,
		XtVaTypedArg, XmNarmColor, XmRString, "pink", 5,
		NULL);

	XtRealizeWidget(topLevel);

	XtAppMainLoop(app);
}
