/*@
 * Copyright(c) 1995-1997 Gregory M. Messner
 * All rights reserved
 *
 * Permission to use, copy, modify and distribute this material for
 * non-commercial personal and educational use without fee is hereby
 * granted, provided that the above copyright notice and this permission 
 * notice appear in all copies, and that the name of Gregory M. Messner
 * not be used in advertising or publicity pertaining to this material
 * without the specific, prior written permission of Gregory M. Messner 
 * or an authorized representative.
 *
 * GREGORY M. MESSNER MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, 
 * EXPRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST INFRINGEMENT OF PATENTS
 * OR OTHER INTELLECTUAL PROPERTY RIGHTS. THE SOFTWARE IS PROVIDED "AS IS",
 * AND IN NO EVENT SHALL GREGORY M. MESSNER BE LIABLE FOR ANY DAMAGES,
 * INCLUDING ANY LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES
 * RELATING TO THE SOFTWARE.
 *
 */


#include	<stdio.h>

#include	<Xm/Xm.h>
#include	"ToolBar.h"
#include	<Xm/CascadeB.h>
#include	<Xm/Separator.h>
#include	<Xm/RowColumn.h>
#include	"ToolPushB.h"
#include	"ExtPushB.h"
#include	"ComboBox.h"
#include	<Xm/Form.h>


#include 	"CancelPB.xpm"
#include	"HandSign.xpm"
#include	"HelpPB.xpm"
#include	"NoPB.xpm"
#include	"OkayPB.xpm"
#include	"YesPB.xpm"


#define RES_CONVERT(r, v)   XtVaTypedArg, r, XmRString, v, strlen(v) + 1

static Widget toolbar;

String	names[] = {"popup_FilePane*FilePane*Open", 
	"popup_FilePane*FilePane*Close", "popup_FilePane*FilePane*Exit"};



static void
exitCB()
{
	exit(0);
}


static void
cloneListCB()
{
int	i, count;
String	*names;

	XgToolBarGetClones(toolbar, &names, &count);

printf("Clone count: %d\n", count);

	for ( i = 0; i < count; i++ )
		printf("Clone[%d]=%s\n", i, names[i]);
	
	XtFree((char *)names);
}


static void
setClonesCB()
{
	XgToolBarSetClones(toolbar, names, 3);
}



static Widget
createMenu(parent)
Widget parent;
{
Widget menuBar, fileBtn, filePane, openBtn, closeBtn, exitBtn, w;
Pixel fg, bg;

	menuBar = XmCreateMenuBar(parent, "MenuBar", NULL, 0);

	filePane = XmCreatePulldownMenu(menuBar, "FilePane", NULL, 0);

	XtVaCreateManagedWidget("File", xmCascadeButtonWidgetClass, menuBar,
		RES_CONVERT(XmNlabelString, "File"),
		XmNmnemonic, 'F',
		XmNsubMenuId, filePane,
		NULL);

	openBtn = XtVaCreateManagedWidget("Open", xgToolPushButtonWidgetClass,
		filePane, 
		RES_CONVERT(XmNlabelString, "Open"), NULL);

	XtAddCallback(openBtn, XmNactivateCallback, cloneListCB, NULL);

        XtVaCreateManagedWidget("Close", xgToolPushButtonWidgetClass,
                filePane,      		
		RES_CONVERT(XmNlabelString, "Close"), NULL);

	w = XtVaCreateManagedWidget("separator", xmSeparatorWidgetClass,
		filePane, NULL);

	w = XtVaCreateManagedWidget("Clone", xgToolPushButtonWidgetClass,
		filePane,
		RES_CONVERT(XmNlabelString, "Clone"), NULL);

	XtAddCallback(w, XmNactivateCallback, setClonesCB, NULL);


        exitBtn = XtVaCreateManagedWidget("Exit", xgToolPushButtonWidgetClass,
                filePane,       
		RES_CONVERT(XmNlabelString, "Exit"), NULL);

	XtAddCallback(exitBtn, XmNactivateCallback, exitCB, NULL);

	XtVaSetValues(menuBar,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_FORM,
		NULL);

	XtManageChild(menuBar);

	return menuBar;
}


static Widget
cloneComboBox(parent, sibling)
Widget parent, sibling;
{

	return XgToolBarDefaultCloner(parent, XtParent(sibling), NULL);

}



main(argc, argv)
int	argc;
char	**argv;
{	
Widget	 	topLevel;
Widget		form, toolBar, toolBar1, form1;	
Widget		button, w, menu;
XtAppContext	app;
int		i;
Pixmap		pix;




	topLevel = XtVaAppInitialize(&app,
		"Test",
		NULL, 0,
		&argc, argv,
		NULL,
		NULL);



	form = XtVaCreateManagedWidget(NULL, 
		xmFormWidgetClass, topLevel, NULL);

	w = XtVaCreateWidget(NULL, 
		xgExtPushButtonWidgetClass, form,
		XgNextLabelType, XgPIXMAP_DATA,
		XgNextPixmap, HandSign_xpm,
		NULL);

	XtVaGetValues(w, XmNlabelPixmap, &pix, NULL);

	menu = createMenu(form);

	toolBar = XtVaCreateManagedWidget(NULL, 
		xgToolBarWidgetClass, form, 
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNbottomAttachment, XmATTACH_NONE,
		XmNtopWidget, menu,
		XmNorientation, XmHORIZONTAL, NULL);

	toolbar = toolBar;


	toolBar1 = XtVaCreateManagedWidget(NULL, 
		xgToolBarWidgetClass, form, 
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_NONE,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNorientation, XmHORIZONTAL, NULL);

	form1 = XtVaCreateManagedWidget(NULL, xmFormWidgetClass, form,
                XmNleftAttachment, XmATTACH_FORM,
                XmNrightAttachment, XmATTACH_FORM,
                XmNtopAttachment, XmATTACH_WIDGET,
                XmNbottomAttachment, XmATTACH_WIDGET,
	        XmNbottomWidget, toolBar1,
		RES_CONVERT(XmNbackground, "White"),
                XmNtopWidget, toolBar, NULL);


	w = XtVaCreateManagedWidget("ComboBox", 
		xgComboBoxWidgetClass, form1,
		NULL);
	XgToolBarRegisterWidget(XgComboBoxGetChild(w, XmDIALOG_TEXT), 
		cloneComboBox, NULL);


	XtRealizeWidget(topLevel);


	XtAppMainLoop(app);
}



