import os, sys

import rox
from rox import g, TRUE, FALSE, choices, filer
import actions
import options

tips = g.Tooltips()

def become_handler(mode):
	"Send a SOAP message to the filer so we become the default handler."
	options.mode = mode
	options.save()
	# Send message...
	app = os.path.abspath(os.path.dirname(sys.argv[0]))
	cin = os.popen('rox -R', 'w')
	cin.write("""<?xml version="1.0"?>
<env:Envelope xmlns:env="http://www.w3.org/2001/12/soap-envelope">
  <env:Body xmlns="http://rox.sourceforge.net/SOAP/ROX-Filer">
   <SetBackdropApp><App>""" + app + """</App></SetBackdropApp>
  </env:Body>
</env:Envelope>
""")

class Activate(g.Alignment):
	def __init__(self, mode):
		g.Alignment.__init__(self, 1, 1, 0, 0)
		button = rox.ButtonMixed(g.STOCK_APPLY, 'Activate %s mode' % mode.name)
		button.set_flags(g.CAN_DEFAULT)
		self.add(button)
		button.connect('clicked', lambda w: become_handler(mode.name))
		mode.pack_start(self, TRUE, TRUE, 0)
		button.grab_default()

class ChangeTime(g.HBox):
	def __init__(self):
		g.HBox.__init__(self, FALSE, 0)
		self.pack_start(g.Label('Change every'), FALSE, TRUE, 0)
		spin = g.SpinButton(options.change_time)
		self.pack_start(spin, FALSE, TRUE, 4)
		self.pack_start(g.Label('minutes'), FALSE, TRUE, 0)
		tips.set_tip(spin, 'The backdrop is changed each time the pinboard '
				   'is loaded (eg, when you log in). You can also get it '
				   'to change after a set interval by making this number '
				   'non-zero.')

class Advanced(g.VBox):
	name = 'Advanced'
	def __init__(self):
		g.VBox.__init__(self, FALSE, 4)
		self.set_border_width(4)

		label = g.Label('Enter a command to run which will write a backdrop image '
				'to its standard output stream. Eg: xearth -png -nice 4')
		label.set_selectable(TRUE)
		label.set_line_wrap(TRUE)
		self.pack_start(label, FALSE, TRUE, 0)

		hbox = g.HBox(FALSE, 0)
		hbox.pack_start(g.Label('Command:'), FALSE, TRUE, 0)

		command = g.Entry()
		command.set_text(options.advanced_command)
		command.grab_focus()
		def entry_changed(entry):
			options.advanced_command = entry.get_text()
		command.connect('changed', entry_changed)
		hbox.pack_start(command, TRUE, TRUE, 0)
		self.pack_start(hbox, FALSE, TRUE)

		self.pack_start(ChangeTime(), FALSE, TRUE, 0)

class RandomBackdrop(g.VBox):
	name = 'Random'

	def __init__(self):
		g.VBox.__init__(self, FALSE, 4)
		self.set_border_width(4)

		def endir(dir):
			if not os.path.exists(dir):
				os.mkdir(dir)
		def add_opendir(label, dir):
			button = g.Button(label)
			button_box.pack_start(button, FALSE, TRUE, 0)
			def open(button):
				path = choices.save('Wallpaper', dir)
				endir(path)
				filer.open_dir(path)
			button.connect('clicked', open)

		label = g.Label('Click on the buttons below to open your image '
				'directories. Copy, move or symlink images into '
				'each directory, depending on how you want each '
				'one displayed.')
		label.set_line_wrap(TRUE)
		self.pack_start(label, FALSE, TRUE, 0)

		align = g.Alignment(0.5, 0.5, 0, 0)
		self.pack_start(align, FALSE, TRUE, 0)
		button_box = g.VBox(TRUE, 2)
		align.add(button_box)
		add_opendir('Tiled images', 'Tiled')
		add_opendir('Scaled images', 'Scaled')
		add_opendir('Centred images', 'Centred')

		self.pack_start(ChangeTime(), FALSE, TRUE, 0)

modes = [RandomBackdrop(), Advanced()]

# From ROX-Lib, but let users off the upgrade tread-mill for one version ;-)
class Dialog(g.Dialog):
	"""This works in exactly the same way as a GtkDialog, except that
	it calls the toplevel_(un)ref functions for you automatically."""
	def __init__(*args, **kwargs):
		apply(g.Dialog.__init__, args, kwargs)
		rox.toplevel_ref()
		args[0].connect('destroy', rox.toplevel_unref)

class Window(Dialog):
	def __init__(self):
		Dialog.__init__(self)
		self.set_title('Wallpaper')
		self.set_position(g.WIN_POS_CENTER)
		self.set_has_separator(FALSE)

		# Add the buttons...

		self.add_button(g.STOCK_CLOSE, g.RESPONSE_CANCEL)

		def response(dialog, response):
			if response == g.RESPONSE_CANCEL:
				self.destroy()
		self.connect('response', response)

		notebook = g.Notebook()
		self.vbox.pack_start(notebook, TRUE, TRUE, 0)
		notebook.set_border_width(4)

		for m in modes:
			notebook.append_page(m, g.Label(m.name))
			Activate(m)

		self.vbox.show_all()

		try:
			i = [m.name for m in modes].index(options.mode)
		except:
			pass
		else:
			notebook.set_current_page(i)
