/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Point;
import java.util.Random;
import java.util.Vector;

public class PointData {
    Random dice = new Random(0L);
    int currentLevel;
    int maxLevel;
    Vector particles;
    int maxParticleNo = 300;
    ResultData orgData;
    Color cl;
    DPos pos;
    Vector areaData;
    Vector rings;
    double[] brtable = new double[]{1.0, 0.9, 0.8, 0.7, 0.45, 0.4, 0.3, 0.2, 0.2, 0.1};

    public PointData(int n, int n2, ResultData resultData) {
        this.maxLevel = n2;
        this.currentLevel = n;
        this.particles = new Vector();
        this.orgData = resultData;
        this.orgData.setPointData(this);
        this.rings = new Vector();
        this.cl = Color.yellow;
        this.pos = new DPos();
    }

    public boolean getFinished() {
        if (this.orgData == null) {
            return false;
        }
        return this.orgData.getFinishedFlag();
    }

    public boolean getSelected() {
        if (this.orgData == null) {
            return false;
        }
        return this.orgData.getSelected();
    }

    public void setSelected(boolean bl) {
        if (this.orgData != null) {
            this.orgData.setSelected(bl);
        }
    }

    public int getLevel() {
        return this.currentLevel;
    }

    public void setLevel(int n) {
        this.currentLevel = n;
    }

    public void addLevel() {
        ++this.currentLevel;
        if (this.currentLevel >= this.maxLevel) {
            this.currentLevel = 0;
        }
    }

    public double getProgValue() {
        return this.orgData.getProgValue();
    }

    public String getProgString() {
        return this.orgData.getProgString();
    }

    public String getCpuString() {
        return this.orgData.getCpuString();
    }

    public String getRemainCpuString() {
        return this.orgData.getRemainCpuString();
    }

    public ResultData getOrgData() {
        return this.orgData;
    }

    public void setColor(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("Yellow")) {
            this.cl = Color.yellow;
        } else if (string.equals("LightBlue")) {
            this.cl = Color.getHSBColor(0.5f, 0.5f, 1.0f);
        } else if (string.equals("Green")) {
            this.cl = Color.getHSBColor(0.32f, 0.51f, 1.0f);
        } else if (string.equals("Magenta")) {
            this.cl = Color.getHSBColor(0.83f, 0.5f, 1.0f);
        } else if (string.equals("Orange")) {
            this.cl = Color.getHSBColor(0.073f, 0.7f, 1.0f);
        } else if (string.equals("Pink")) {
            this.cl = Color.pink;
        } else if (string.equals("Red")) {
            this.cl = Color.getHSBColor(0.0f, 0.6f, 1.0f);
        } else if (string.equals("White")) {
            this.cl = Color.white;
        }
    }

    public Color getColor() {
        return this.cl;
    }

    public boolean getVisible() {
        return this.orgData.getVisible();
    }

    public DPos getPoint() {
        this.pos.setPos(this.orgData.getPoint());
        return this.pos;
    }

    public DPos getEndPoint() {
        this.pos.setPos(this.orgData.getEndPoint());
        return this.pos;
    }

    public Vector getBgpot() {
        if (this.orgData == null) {
            return null;
        }
        return this.orgData.getBgpot();
    }

    public double getBgTrueMean() {
        if (this.orgData == null) {
            return 0.0;
        }
        return this.orgData.getBgTrueMean();
    }

    public double getBgPower() {
        if (this.orgData == null) {
            return 0.0;
        }
        return this.orgData.getBgPower();
    }

    public double getBgChisq() {
        if (this.orgData == null) {
            return 0.0;
        }
        return this.orgData.getBgChisq();
    }

    public void resetDPoints() {
        this.pos.resetDPoint();
        if (this.areaData != null) {
            int n = 0;
            while (n < this.areaData.size()) {
                DPos dPos = (DPos)this.areaData.elementAt(n);
                dPos.resetDPoint();
                ++n;
            }
        }
    }

    public boolean getTop() {
        if (this.orgData == null) {
            return false;
        }
        return this.orgData.getTop();
    }

    public void addParticle(Point point, int n, int n2, int n3) {
        int n4 = this.particles.size() + n;
        int n5 = 0;
        while (n5 < n4 - this.maxParticleNo) {
            this.particles.removeElement((ParticleData)this.particles.elementAt(0));
            ++n5;
        }
        int n6 = 0;
        while (n6 < n) {
            this.particles.addElement(this.genParticle(point, n2, n3));
            ++n6;
        }
    }

    private ParticleData genParticle(Point point, int n, int n2) {
        int n3 = (int)(this.dice.nextDouble() * (double)n) + n;
        double d = this.dice.nextDouble() * 2.0 * 3.1416;
        return new ParticleData(point.x, point.y, n2, n3, d);
    }

    public Vector getPtVect() {
        Vector<ParticleData> vector = new Vector<ParticleData>();
        int n = 0;
        while (n < this.particles.size()) {
            ParticleData particleData = (ParticleData)this.particles.elementAt(n);
            particleData.act();
            if (particleData.getLifeValue() < 0.1) {
                vector.addElement(particleData);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            this.particles.removeElement((ParticleData)vector.elementAt(n2));
            ++n2;
        }
        return this.particles;
    }

    public void getAreaData(Vector vector) {
        if (this.areaData == null) {
            this.areaData = new Vector();
            Vector vector2 = new Vector();
            this.orgData.getAreaData(vector2);
            int n = 0;
            while (n < vector2.size()) {
                TDPoint tDPoint = (TDPoint)vector2.elementAt(n);
                this.areaData.addElement(new DPos(tDPoint));
                ++n;
            }
        }
        int n = 0;
        while (n < this.areaData.size()) {
            DPos dPos = (DPos)this.areaData.elementAt(n);
            vector.addElement(dPos);
            ++n;
        }
    }

    public boolean hasLingP() {
        return this.rings.size() != 0;
    }

    public void initRings() {
        int n = 0;
        while (n < this.maxLevel) {
            this.rings.addElement(new SRing(7, this.brtable[n]));
            ++n;
        }
    }

    public Vector getRings() {
        return this.rings;
    }

    public void rotate() {
        int n = 0;
        while (n < this.rings.size()) {
            SRing sRing = (SRing)this.rings.elementAt(n);
            sRing.rotate(13 - n);
            ++n;
        }
    }
}

