
/* "WOL", an integrated circuit layout tool,
   Copyright (C) 1983, 1990 California Institute of Technology.
   Author: Massimo Sivilotti
   Thanks to: Glenn Gribble, Marty Sirkin, Sylvie Rychebusch
	      Maryann Mayer, Carver Mead, Rick Koshi, Torre Lande
   Maintainer: John Lazzaro
   Maintainers's address: lazzaro@hobiecat.cs.caltech.edu;
                          CB 425/ CU Boulder/Boulder CO 91125. 
			  Send questions, bug fixes, to this address.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (Version 1, 1989).

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* Output from p2c, the Pascal-to-C translator */
/* p2c: wolopt.text, line 9: Note: Range checking is OFF [216] */
/* p2c: wolopt.text, line 10: Note: Stack checking is OFF [217] */
/* p2c: wolopt.text, line 16: Note: Range checking is ON [216] */
/* From input file "cell_stuff.text" */


/* Change these for testing */



#include "global.h"


#define CELL_STUFF_G
#include "cell_stuff.h"


const point zero_point = {
  0, 0
};


#define co_g_cell       0   /* Constants for core_alloc */
#define co_c_cell       1
#define co_c_c_cell     2
#define co_a_w_node     3
#define co_a_node       4
#define co_routing_node  5
#define co_port_node    6


/* Local variables for cell_init: */
struct LOC_cell_init {
  boolean error;
} ;

Local void add(long size, Char *name, long num, struct LOC_cell_init *LINK)
{
  long real;

  real = core_add(size, name);
  if (real != num) {
    printf("\007Core_add of \"%s\" returned %ld not %ld\n", name, real, num);
    LINK->error = true;
  }
}


void cell_init(void)
{
  struct LOC_cell_init V;

  V.error = false;
  core_init();

  add(sizeof(cell), "geom_cell", co_g_cell, &V);
  add(sizeof(comp_list), "comp_list", co_c_cell, &V);
  add(sizeof(c_cell), "comp_cell", co_c_c_cell, &V);
  add(sizeof(a_w_node), "a_w_node", co_a_w_node, &V);
  add(sizeof(node), "node", co_a_node, &V);
  add(sizeof(routing), "routing", co_routing_node, &V);
  add(sizeof(port_node), "port node", co_port_node, &V);

}


void check_mem(void)
{
  long x, y;

  if (memavail() >= mem_thresh)
    return;
  if (sysclock() > last_mem_low + 500 || sysclock() < last_mem_low) {
    show_message("\007Low on memory", true);
    printf("Only %ld bytes left!!!\n", memavail());
    printf("\007Save what you are doing now!!\n");
    printf("Then exit and restart WOL... or risk loosing it all.\n");
    last_mem_low = sysclock();
    return;
  }
  nk_getxy(&x, &y);
  nk_gotoxy(0, 24);
  printf(" Low on memory, only %ld bytes left!!!", memavail());
  nk_gotoxy(x, y);
}


/*******************************************************************************/

cell *get_g_cell(void)
{
  cell *tgac;

#if 0
  tgac = (cell *)malloc(sizeof(tgac));
  memset(tgac, 0, sizeof(tgac));
#else
  core_cnew((core_rec **)(&tgac), co_g_cell);
#endif
      /* initialize non-zero things */
  tgac->modified = true;   /* New, therefore modified */
  return tgac;
}


/*******************************************************************************/

void recl_g_cell(cell **c)
{
  if (*c != NULL)
    core_free((core_rec **)c);
}


/*******************************************************************************/

comp_list *get_c_cell(void)
{
  comp_list *tgac;

#if 0
  tgac = (comp_list *)malloc(sizeof(comp_list));
  memset(tgac, 0, sizeof(comp_list));
#else
  core_cnew((core_rec **)(&tgac), co_c_cell);
#endif
  tgac->modified = true;   /* New, therefore modified */
  tgac->correct_mbb = false;
  return tgac;
}


/*******************************************************************************/

void recl_c_cell(comp_list **c)
{
  c_cell *t_c, *t_cc;

  if (*c == NULL)
    return;
  t_c = (*c)->data;
  while (t_c != NULL) {
    t_cc = t_c;
    t_c = t_c->next;
    recl_c_c_cell(&t_cc);
  }
  core_free((core_rec **)c);
}


/*******************************************************************************/

c_cell *get_c_c_cell(void)
{
  c_cell *tgac;

#if 0
  tgac = (c_cell *)malloc(sizeof(c_cell));
  memset(tgac, 0, sizeof(c_cell));
#else
  core_cnew((core_rec **)(&tgac), co_c_c_cell);
#endif
  tgac->status = CLOSED;
  tgac->tag = COMP;
  tgac->correct_mbb = false;
  return tgac;
}


/*******************************************************************************/

void recl_c_c_cell(c_cell **c)
{
  if (*c != NULL)
    core_free((core_rec **)c);
}


/*******************************************************************************/

a_w_node *get_a_w_node(void)
{
  a_w_node *tgac;

#if 0
  tgac = (a_w_node *)malloc(sizeof(a_w_node));
  memset(tgac, 0, sizeof(a_w_node));
#else
  core_cnew((core_rec **)(&tgac), co_a_w_node);
#endif
  return tgac;
}


/*******************************************************************************/

void recl_a_w_node(a_w_node **c)
{
  a_w_node *t_c;

  while (*c != NULL) {
    t_c = (*c)->next;
    core_free((core_rec **)c);
    *c = t_c;
  }
}


/*******************************************************************************/

port_node *get_port_node(void)
{
  port_node *tgan;

#if 0
  tgan = (port_node *)malloc(sizeof(port_node));
  memset(tgan, 0, sizeof(port_node));
#else
  core_cnew((core_rec **)(&tgan), co_port_node);
#endif
  tgan->layerno = 1;
  tgan->width = 4;
  tgan->next = NULL;
  return tgan;
}


/*******************************************************************************/

void recl_port_nodes(port_node **c)
{
  port_node *t_c;

  while (*c != NULL) {
    t_c = (*c)->next;
    core_free((core_rec **)c);
    *c = t_c;
  }
}


/*******************************************************************************/

routing *get_routing_node(void)
{
  routing *tgan;

#if 0
  tgan = (routing *)malloc(sizeof(routing));
  memset(tgan, 0, sizeof(routing));
#else
  core_cnew((core_rec **)(&tgan), co_routing_node);
#endif
  tgan->layer = 1;
  tgan->width = 4;
  return tgan;
}


/*******************************************************************************/

void recl_routing_node(routing **n)
{
  routing *nxt;

  while (*n != NULL) {
    nxt = (*n)->to_point;
    core_free((core_rec **)n);
    *n = nxt;
  }
}


/*******************************************************************************/

node *get_a_node(void)
{
  node *tgan;

#if 0
  tgan = (node *)malloc(sizeof(node));
  memset(tgan, 0, sizeof(node));
#else
  core_cnew((core_rec **)(&tgan), co_a_node);
#endif
  tgan->layer = 1;
  tgan->portlist = NULL;
  return tgan;
}


/*******************************************************************************/

void recl_nodes(node **n)
{
  node *nxt;

  while (*n != NULL) {
    recl_port_nodes(&(*n)->portlist);
    recl_nodes(&(*n)->child);
    nxt = (*n)->next;
    core_free((core_rec **)n);
    *n = nxt;
  }
}


/*******************************************************************************/

/* module CELL_STUFF */




/* End. */

