/* Header for module cell_stuff, generated by p2c */
#ifndef CELL_STUFF_H
#define CELL_STUFF_H


/* define the major cell stuff in use */

#ifndef SYSGLOBALS_H
#include <p2c/sysglobals.h>
#endif

#ifndef SYSDEVS_H
#include <p2c/sysdevs.h>
#endif

#ifndef NEWKBD_H
#include <p2c/newkbd.h>
#endif

#ifndef MYLIB_H
#include <p2c/mylib.h>
#endif

/* General stuff for dealing with layers.  This is placed in a module to put */
/* everything in one place.  Some conventions for dealing with layers, etc.: */
/*    Every routine is responsible for setting the current layer/color/... to*/
/*       its desired value.  This requires some slight caution when calling  */
/*       other routines, but means that box drawing routines do not need to  */
/*       save and restore the color each time for each call.                 */

#ifndef LAYER_STUFF_H
#include "layer_stuff.h"
#endif

#ifndef MESSAGE_STUFF_H
#include "message_stuff.h"
#endif

#ifndef CORE_H
#include "core.h"
#endif


#ifdef CELL_STUFF_G
# define vextern
#else
# define vextern extern
#endif


/*coord      = shortint;  { All coordinates are this??? */
/* MAS Jan 17,1985 -- to overcome large cells */

/* Type of cell names */
/* elec node names, usually set to str10 */
/* should be long enough for get_date_string */
typedef enum {
  GEOM, COMP
} cell_typ;   /* Type of cell       */

typedef struct point {
  /* Define a point */
  long x, y;
} point;


vextern point zero_point;


typedef enum {
  OPENED, CLOSED, JUST_CLOSED
} poke_state;

/*******************************************************************************/

typedef struct prefixid_nodes {
  struct prefixid_nodes *next;
  long id;   /* unique number for each cell instance */
} prefixid_nodes;

typedef struct routing {
  point pt1, pt2;
  short layer, width;
  Char name[11];
  struct routing *next, *to_point;
} routing;

typedef struct port_node {
  point p1, p2;
  Char side;
  Char layer[11];   /* CIF layer name */
  long layerno;   /* WOL number for layer */
  Char signaltype[81];
  long width;
  struct port_node *next;
  Char name[11];
} port_node;

typedef struct node {
  struct node *child, *next, *parent;
  point ll, ur;
  short layer;
  port_node *portlist;
  Char name[11];
} node;

typedef node *box_array[max_layer - min_layer + 1];

typedef struct cell {
  /* of defined geometry cells */
  struct cell *next, *prev;
  node *data;
  point ll;   /* Bounding box */
  point ur;
  Char name[81];
  boolean modified;
  prefixid_nodes *prefixid_list;
  port_node *portlist;
  short revision_number;
  Char revision_date[31];
  box_array boxes;   /* for extract */
} cell;


typedef struct c_cell {
  point ll, ur;
  boolean correct_mbb;   /* used by update_comp_mbb */
  short xform;
  struct c_cell *next, *select_list;   /* keeps track of original cell */
  poke_state status;
  Char prefix[11];
  long prefixid;   /* default prefix id */
  cell_typ tag;
  union {
    cell *g_d;
    struct {
      struct comp_list *c_d, *old_c_d;
    } U1;
  } UU;
} c_cell;

typedef struct comp_list {
  Char name[81];
  point ll, ur;   /* B.B */
  boolean correct_mbb;   /* used by update_comp_mbb */
  struct comp_list *next;
  c_cell *data;
  prefixid_nodes *prefixid_list;
  boolean modified;
  routing *routing_;
  short revision_number;
  Char revision_date[31];
} comp_list;

typedef struct a_w_node {
  struct a_w_node *next;
  short sym_num;
  Char name[81];
} a_w_node;


vextern long init_mem;   /* Number of free bytes at start.    */
vextern long mem_thresh;   /* Minimum amount of free memory GEG */
vextern long last_mem_low;   /* Last time memory low was reported GEG */

vextern cell *geom_cells;   /* List of geometry cells    */
vextern comp_list *comp_cells;   /* List of composition cells */
vextern c_cell *comp_undelete_list;   /* List of deleted composition cells */


extern void cell_init(void);

extern void check_mem(void);

extern cell *get_g_cell(void);
extern comp_list *get_c_cell(void);
extern c_cell *get_c_c_cell(void);
extern a_w_node *get_a_w_node(void);
extern node *get_a_node(void);
extern routing *get_routing_node(void);
extern port_node *get_port_node(void);

extern void recl_g_cell(cell **c);
extern void recl_c_c_cell(c_cell **c);
extern void recl_c_cell(comp_list **c);
extern void recl_a_w_node(a_w_node **c);
extern void recl_nodes(node **n);
extern void recl_routing_node(routing **n);
extern void recl_port_nodes(port_node **c);


#undef vextern

#endif /*CELL_STUFF_H*/

/* End. */
