/* Header for module core, generated by p2c */
#ifndef CORE_H
#define CORE_H


/* Simple core allocator module */
/* Does not rejoin small regions to make large regions */

#ifndef NEWASM_H
#include <p2c/newasm.h>
#endif


#ifdef CORE_G
# define vextern
#else
# define vextern extern
#endif


#define core_max_kinds  10
#define core_magic      18172   /* Generic random number */
#define core_marker     (-37)   /* "Kind" for a core-marker */


typedef struct core_rec {
  short magic;   /* Magic number */
  short kind;   /* Which kind */
  struct core_rec *next;   /* Used only while on free list */
} core_rec;

typedef struct core_info_rec {
  /* One of these records for each kind */
  core_rec *list;   /* Free list */
  long size;   /* Size of item (including header) */
  long free;   /* Number on free list */
  long used;   /* Number currently used */
  long alloc;   /* Number allocated==free+used */
  long news;   /* Number of calls to new */
  long frees;   /* Number of calls to free */
  long rels;   /* Number of things released */
  Char name[26];   /* For core_stats routine */
} core_info_rec;


vextern core_info_rec core_info[core_max_kinds];
vextern short core_kinds;
vextern core_rec *core_base;   /* Set when core_init is called. */


extern void core_init(void);
extern long core_add(long s, Char *n);
extern void core_new(core_rec **ptr, short kind);
extern void core_cnew(core_rec **ptr, short kind);
extern void core_free(core_rec **ptr);
extern void core_stats(FILE **out);
extern void core_mark(core_rec **ptr);
extern void core_release(core_rec **ptr);


#undef vextern

#endif /*CORE_H*/

/* End. */
