/* Header for module ext_defs, generated by p2c */
#ifndef EXT_DEFS_H
#define EXT_DEFS_H


#ifndef ASM_H
#include <p2c/asm.h>
#endif

#ifndef SYSGLOBALS_H
#include <p2c/sysglobals.h>
#endif

/*file support*/

#ifndef FS_H
#include <p2c/fs.h>
#endif

#ifndef MISC_H
#include <p2c/misc.h>
#endif

#ifndef SYSDEVS_H
#include <p2c/sysdevs.h>
#endif

/* by      Tim Mikkelsen
   date    07/17/81
   update  03/09/83

   purpose This module contains the LEVEL
           2 HPIB GROUP procedures.

 */


#ifndef HPIB_2_H
#include <p2c/hpib_2.h>
#endif

#ifndef HPIB_1_H
#include <p2c/hpib_1.h>
#endif

#ifndef GENERAL_1_H
#include <p2c/general_1.h>
#endif

#ifndef GENERAL_2_H
#include <p2c/general_2.h>
#endif

#ifndef FILEPACK_H
#include <p2c/filepack.h>
#endif

#ifndef NEWKBD_H
#include <p2c/newkbd.h>
#endif

#ifndef MYLIB_H
#include <p2c/mylib.h>
#endif

#ifndef NEWCI_H
#include <p2c/newci.h>
#endif

#ifndef NEWASM_H
#include <p2c/newasm.h>
#endif

#ifndef WOL_GRAPHICS_H
#include "wol_graphics.h"
#endif

#ifndef WOL_ASM_H
#include "wol_asm.h"
#endif

#ifndef HPGL_PLOTTER_H
#include "hpgl_plotter.h"
#endif

#ifndef TIMING_H
#include "timing.h"
#endif

#ifndef LAYER_STUFF_H
#include "layer_stuff.h"
#endif

#ifndef TABLET_STUFF_H
#include "tablet_stuff.h"
#endif

#ifndef MESSAGE_STUFF_H
#include "message_stuff.h"
#endif

#ifndef CORE_H
#include "core.h"
#endif

#ifndef CELL_STUFF_H
#include "cell_stuff.h"
#endif

#ifndef NAME_STUFF_H
#include "name_stuff.h"
#endif

#ifndef WOL_HEADER_H
#include "wol_header.h"
#endif

#ifndef WOL_GRAPHICS_2_H
#include "wol_graphics_2.h"
#endif


#ifdef EXT_DEFS_G
# define vextern
#else
# define vextern extern
#endif


/*USE_CON_REC = false;*/
/* Change me to use/eliminate hcon/vcon stuff */

#define USE_CON_REC     true
    /* Change me to use/eliminate hcon/vcon stuff */

#define ext_version     "xtr 1.00: Bin/Lyr/box:w-s-p"

/* min_layer = 1;  */
/* max_layer = 28; Defined in layer_stuff */
/***/

#define min_node        0
/* Well known nodes */
#define GROUND          min_node

#define VDD             (GROUND + 1)

#define max_node        500000
/*256*/
#define node_thresh     1024
    /* How far over prev maxnode to go before mash */
#define max_tran        100000   /* Max number of transistors of either kind */


/* WARNING: these layer constants are dependent on the */
/*    technology file!!! */
#define layer_poly      1
#define layer_diff      2
#define layer_metal     3
#define layer_well      4
#define layer_cutp      5
#define layer_cuta      6
#define layer_glass     7
#define layer_metal2    8
#define layer_sel       9
#define layer_via       10
#define layer_poly2     11   /***/
#define layer_cut2      12   /***/

#define layer_d         13
/* Diffusion, no poly, no poly2, no select, no well */
/***/
#define layer_ds        14
/* Diffusion, no poly, no poly2, select, no well */
/***/
#define layer_dw        15
/* Diffusion, no poly, no poly2, no select, well */
/***/
#define layer_dsw       16
/* Diffusion, no poly, no poly2, select, well */
/***/
#define layer_dp        17
/* Diffusion, poly, no poly2, no select, no well */
/***/
#define layer_dp2       18
/* Diffusion, no poly, poly2, no select, no well */
/***/
#define layer_dps       19
/* Diffusion, poly, no poly2, select, no well */
/***/
#define layer_dpw       20
/* Diffusion, poly, no poly2, no select, well */
/***/
#define layer_dpsw      21
/* Diffusion, poly, no poly2, select, well */
/***/
#define layer_dp2s      22
/* Diffusion, no poly, poly2, select, no well */
/***/
#define layer_dp2w      23
/* Diffusion, no poly, poly2, no select, well */
/***/
#define layer_dp2sw     24
/* Diffusion, no poly, poly2, select, well */
/***/
#define layer_dpp2      25
/* Diffusion, poly, poly2, no select, no well */
/***/
#define layer_dpp2s     26
/* Diffusion, poly, poly2, select, no well */
/***/
#define layer_dpp2w     27
/* Diffusion, poly, poly2, no select, well */
/***/
#define layer_dpp2sw    28


/* Diffusion, poly, poly2, select, well */
/***/

typedef Char layer_namet[max_layer - min_layer + 1][10];


/***/
/***/
/***/
vextern const layer_namet layer_names;


/* Nowhere near  */
/* Corners touch */
/* Edges touch   */
typedef enum {
  c_away, c_corner, c_edge, c_over
} clipconds;   /* Overlap       */

typedef struct box_rec {
  struct box_rec *next;
  long llx, lly, urx, ury;
  /* : shortint; */
  /* Coordinates of box */
  long node_;   /*: nodetype;*/
  long mybin;   /* Which bin am I in? */
} box_rec;

typedef struct hcon_rec {
  /* Horizontal box (or connection record ) */
  struct hcon_rec *next;
  long lowx, highx;
  /*: shortint;*/
  /* Coordinates of connection */
  long node_;   /*: nodetype;*/
  long mybin;   /* Which bin? (Indicates Y-coord) */
} hcon_rec;

typedef struct vcon_rec {
  /* Vertical box (or connection record ) */
  struct vcon_rec *next;
  long lowy, highy;
  /* : shortint;*/
  /* Coordinates of connection */
  long node_;   /*: nodetype;*/
  long mybin;   /* Which bin? (Indicates X-coord) */
} vcon_rec;

/*$if sizeof(vcon_rec)<>sizeof(hcon_rec)$ error=1/0; $end$*/

typedef struct layer_rec {
  box_rec *boxes;
  hcon_rec *south;   /* From south neighbor */
  vcon_rec *west;   /* From west neighbor */
} layer_rec;

typedef box_rec *sort_arr[max_layer - min_layer + 1];
typedef long area_arr[max_layer - min_layer + 1];

typedef struct bin_rec {
  layer_rec layers[max_layer - min_layer + 1];
} bin_rec;

typedef bin_rec bin_arr[1048577];
typedef long active_arr[5];   /* allow up to 4 actives */

typedef struct tran_rec {
  long gate, acount;
  active_arr actives;
  long area;
  long len;   /* Pretend length */
  long x, y;   /* Center of one gate */
  box_rec *boxes;
} tran_rec;

typedef long nodenumtype[max_node - min_node + 1];
typedef tran_rec tran_arr[max_tran + 1];


vextern boolean global_debug, xtr_debug, show_node_info, short_diodes;

vextern long maxnode, nodenum;   /* Next free node number */
vextern long lastmax;   /* Last maxnode+node_thresh (at time of mash) */
vextern long total_nodes, orphan_nodes;

vextern long node_found_by_layer;

vextern long *nodenumbers;
vextern tran_rec *ptran, *ptran2;   /***/
vextern tran_rec *ntran, *ntran2;   /***/
vextern bin_rec *bins;
vextern long binwidth, binheight, binx, biny, binmax;
    /* == binx*biny - 1 */

vextern long numptran, numntran, numptran2;   /***/
vextern long numntran2;   /***/
vextern long boxes_added, boxes_checked, boxes_swallow, boxes_clipped,
	     edges_clipped;
vextern Char src_name[81];
vextern long xtrtime, trantime, woltoxtrtime;
vextern void *ext_marker;
/*layer_trans: array[min_layer..max_layer] of shortint;*/
vextern long core_box_kind;   /* Numbers for core allocator */
vextern long core_con_kind;


extern long nextnodenum(void);
extern void freenodenum(long node_);
extern box_rec *new_box();
extern vcon_rec *new_vcon();
extern hcon_rec *new_hcon();
extern void ext_init_mem(void);
extern void re_init_mem(void);
extern void xtr_free_mem(void);
extern void equiv(long n1, long n2);
extern void equivforce(void);
extern void mashnodes(void);


#undef vextern

#endif /*EXT_DEFS_H*/

/* End. */
