/* Header for module layer_stuff, generated by p2c */
#ifndef LAYER_STUFF_H
#define LAYER_STUFF_H


/* General stuff for dealing with layers.  This is placed in a module to put */
/* everything in one place.  Some conventions for dealing with layers, etc.: */
/*    Every routine is responsible for setting the current layer/color/... to*/
/*       its desired value.  This requires some slight caution when calling  */
/*       other routines, but means that box drawing routines do not need to  */
/*       save and restore the color each time for each call.                 */

#ifndef SYSGLOBALS_H
#include <p2c/sysglobals.h>
#endif

/*homeless orphans*/

#ifndef MISC_H
#include <p2c/misc.h>
#endif

#ifndef NEWASM_H
#include <p2c/newasm.h>
#endif

#ifndef MYLIB_H
#include <p2c/mylib.h>
#endif

#ifndef WOL_GRAPHICS_H
#include "wol_graphics.h"
#endif


#ifdef LAYER_STUFF_G
# define vextern
#else
# define vextern extern
#endif


#define min_layer       1
#define max_layer       28   /***/
#define max_styles      7
#define max_patterns    8


typedef struct layer_disp_info {
  boolean deferred;   /* for contact cut stuff */
  short color;   /* border color */
  short style;   /* border linestyle */
  short fcolor;   /* center fill color */
  short fstyle;   /* center fill style */
  /*-1 - no fill */
  /* 0 - solid fill */
  /* 1 - X in fill-color */
  /* 2 - X in fill-color, black out center first */
  /* 3 - even checkerboard */
  /* 4 - odd checkerboard */
  short menu;   /* Which menu square to use */
} layer_disp_info;

typedef struct plotter_disp_info {
  short color;   /* border color */
  short style;   /* border linestyle */
  short fcolor;   /* center fill color */
  short fstyle;   /* center fill style */
  /* No fill styles/colors supported yet */
} plotter_disp_info;

typedef struct layer_info {
  boolean layer_on;   /* Layer on now?? */
  Char menu_name[6];   /* name of layer in menu */
  Char cif_name[6];   /* cif name for layer */
  plotter_disp_info plot;
  layer_disp_info styles[max_styles + 1];
  short numstyles;   /* Number of styles for this layer */
  short bloat;   /* number of 1/2 lambda to bloat by */
} layer_info;   /* information on each layer */

typedef layer_info layer_array[max_layer - min_layer + 1];
/* Junk for fill patterns--see Mylib */

typedef struct pattern {
  schar xsize, ysize, xoff, yoff;
  uchar xdim, ydim, width, height;
  union {
    uchar pic[8][8];
    uchar pica[64];
  } UU;
} pattern;


/* Quick way to tell if a layer is deferred */
vextern boolean deferred[max_layer - min_layer + 1];
vextern boolean layers_on[max_layer - min_layer + 1];
vextern boolean bloats_on[max_layer - min_layer + 1];
vextern layer_array layers;   /* This record contains all of the information*/
/* about all of the layers.  The index into this */
/* table is what is stored in the cell records.  */
vextern short curr_layer;   /* current layer.  Set only by LAYER menu */
vextern short last_layer;   /* last layer set by SET_LAYER call.  Used by */
/* RESET_LAYER. */
/* The next five variables should be thought of as READ-ONLY by */
/*  the main program.  Only this module should change them.     */
vextern short curr_color;   /* Current color */
vextern short curr_style;   /* Current line style */
vextern short curr_fillc;   /* Current fill color */
vextern short curr_fillp;   /* Current fill pattern, if -1 then nofill */
vextern boolean curr_defer;   /* Current layer deferred? */
vextern boolean curr_show;   /* Layer On??? */

vextern short error_layer;   /* the layer that errors are displayed on */

/* If any of the next three variables are changed, then SET_LAYER */
/* or RESET_LAYER must be called to reset CURR_* to the correct values.*/
/* dotted      : boolean;  { draw all dotted lines */
/* ref_in_black: boolean;  { draw all in black */
vextern short disp_style;   /* Which display style to use */
/* Call set_disp_style to change this value. */
vextern short numstyles;   /* Total number of display styles */

/* This an array of pointers to magic pattern characters */
vextern pattern *patterns[max_patterns];


/* fill_boxes  : boolean;  fill boxes?  When this variable is changed, */
/* DRAW_BOXES should be called to fix the top  */
/* display. */

extern void set_disp_style(short new_style);
extern void show_layer(FILE **out, short num);
extern void dump_layers(FILE **out);
extern void read_tech(Char *name);
extern void set_layer(short newlayer);
extern void reset_layer(void);
extern void layers_show_all(void);
extern void pat_fillbox(long x1, long y1, long x2, long y2, long pat);


#undef vextern

#endif /*LAYER_STUFF_H*/

/* End. */
