
/* "WOL", an integrated circuit layout tool,
   Copyright (C) 1983, 1990 California Institute of Technology.
   Author: Massimo Sivilotti
   Thanks to: Glenn Gribble, Marty Sirkin, Sylvie Rychebusch
	      Maryann Mayer, Carver Mead, Rick Koshi, Torre Lande
   Maintainer: John Lazzaro
   Maintainers's address: lazzaro@hobiecat.cs.caltech.edu;
                          CB 425/ CU Boulder/Boulder CO 91125. 
			  Send questions, bug fixes, to this address.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (Version 1, 1989).

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* Output from p2c, the Pascal-to-C translator */
/* p2c: menu.text, line 6: Note: Range checking is OFF [216] */
/* p2c: menu.text, line 7: Note: Stack checking is OFF [217] */
/* p2c: menu.text, line 14: Note: Range checking is ON [216] */
/* From input file "menu.text" */


/* Change these for testing */


/* Caged_date='r{ $X $u $]' */
/* Aug 7, 1985 9:42 pm glenn */

#include "global.h"


#ifndef MYLIB_H
#include <p2c/mylib.h>
#endif

#ifndef NEWASM_H
#include <p2c/newasm.h>
#endif

#ifndef SYSGLOBALS_H
#include <p2c/sysglobals.h>
#endif

/*homeless orphans*/

#ifndef MISC_H
#include <p2c/misc.h>
#endif


/* Tablet procedure */

/* Tablet procedure, with sub-modes */

typedef union menu_ptr {
  long int_;
  void *any;
  struct menu_rec *recp;
  struct menu_head *headp;
  boolean *boolp;
  long *intp;
  Char *strp;
  short *shortp;
} menu_ptr;

typedef enum {
  mn_null, mn_radio, mn_radio2, mn_bool, mn_action, mn_change, mn_layer
} menu_kinds;
typedef Char menu_modes[64][8];

typedef struct menu_submoderec {
  _PROCEDURE t2proc;
  short mode, nummodes;
  Char (*modes)[8];
} menu_submoderec;

typedef struct menu_rec {
  struct menu_rec *next;   /* next menu item in the list */
  Char name[8];   /* Displayed name of this item */
  Char lookup[8];   /* Lookup name of this item */
  short color;   /* Menu name color */
  boolean selected;   /* Currently selected? */
  short pos;   /* Position */
  _PROCEDURE proc;   /* This gets called when selected */

  menu_kinds tag;
  union {
    struct {
      long null1, null2;
    } U0;
    _PROCEDURE tproc;
    menu_submoderec *more;
    boolean *boolp;
    _PROCEDURE aproc;
    Char *strp;
    long layer;
  } UU;
} menu_rec;

typedef struct menu_head {
  struct menu_head *next;   /* Pointer to next full menu */
  menu_rec *menu;   /* Pointer to menu items */
  Char name[8];   /* Name of whole menu */
  _PROCEDURE tproc;   /* Normal tablet procedure */
  _PROCEDURE t2proc;   /* Sub-mode tablet procedure */
  _PROCEDURE init;   /* Called each time the menu is entered. */
  _PROCEDURE exit;   /* Called each time the menu is exited. */
  Char modestr[8];   /* ALL, ONE, SEL, ... */
  short modenum;   /* Numeric value of modestr (-1 if no mode) */
} menu_head;


#define border_color    6
#define select_color    5
#define square_size     45   /* size of menu squares */
#define square_max      10   /* maximum number of menu squares */


Static menu_head *all_menus, *menu_curr, *menu_prev;
Static boolean menu_erase;   /* Erase menu next time it is drawn? */

Static short menu_pos;   /* Which menu item? */

Static Char comp_menu[8];   /* Which comp-menu was I last in? */
Static long curr_layer;

Static boolean layers_on[17];

Static boolean gbool, quit;


Static void new_menu(Char *name, _PROCEDURE tproc, _PROCEDURE init,
		     _PROCEDURE exit)
{
  menu_curr = Malloc(sizeof(menu_head));
  strcpy(menu_curr->name, name);
  sprintf(menu_curr->modestr, "%.5s", name);
  menu_curr->modenum = -1;
  menu_curr->menu = NULL;
  menu_curr->tproc = tproc;
  menu_curr->init = init;
  menu_curr->exit = exit;
  menu_curr->next = all_menus;
  all_menus = menu_curr;

  menu_pos = 0;
}


/* Allocate a new menu at the start of menu_curr */
Static menu_rec *menu_add(Char *name, menu_kinds tag, short color,
			  _PROCEDURE proc)
{
  menu_rec *Result, *p;

  p = Malloc(sizeof(menu_rec));
  strcpy(p->name, name);
  strcpy(p->lookup, name);
  p->color = color;
  p->selected = false;
  p->proc = proc;
  p->pos = menu_pos;
  p->tag = tag;
  p->UU.U0.null1 = 0;
  p->UU.U0.null2 = 0;
  p->next = menu_curr->menu;
  menu_curr->menu = p;
  Result = p;

  menu_pos++;
  return Result;
}


Static void menu_show(void)
{
  menu_rec *p;
  long r;   /* right hand edge */
  menu_rec *WITH;

  p = menu_curr->menu;
  /*writeln('Menu: ',menu_curr^.name);*/
  while (p != NULL) {
    WITH = p;
    r = WITH->pos * square_size;
    if (menu_erase) {
      m_color(0);
      m_fillrect(r + 1, 370, r + square_size - 2, 388);
    }
    m_color(WITH->color);
    m_centerstr(r + 22, 382, NULL, WITH->name);
    if (WITH->selected)
      m_color(select_color);
    else
      m_color(border_color);
    m_drawrect(r, 369, r + square_size - 1, 389);

    /*writeln(pos:5,'=',name,' @ ',color:1,' s=',selected:1,' p1=',p1:1);*/
    p = WITH->next;
  }

  /* Clear all of the color/mode display */
  m_color(0);
  m_fillrect(square_size * 10, 369, 511, 389);

  /* set_layer(curr_layer);                 { Reset to normal layer */
  m_color(curr_layer);
  m_fillrect(463, 375, 473, 384);   /* Display layer box */
  m_color(7);
  m_rightstr(511, 382, NULL, menu_curr->modestr);

  menu_erase = false;
}


Static void menu_press(menu_rec *item)
{
  if (item == NULL) {
    printf("menu_press: item=NIL\n");
    return;
  }
  if (item->proc.link != NULL)
    ((void(*)(menu_rec *mp, void *_link))item->proc.proc)(item, item->proc.link);
  else
    ((void(*)(menu_rec *mp))item->proc.proc)(item);
}


/* Return true if pen was within menu area */
Static boolean menu_check(long x, long y)
{
  boolean Result;
  menu_rec *mp;
  long sq;

  Result = false;
  if (y < 369)
    return Result;
  Result = true;

  sq = x / square_size;
  if ((unsigned long)sq >= 10)
    return Result;
  mp = menu_curr->menu;
  while (mp != NULL) {
    if (mp->pos != sq) {
      mp = mp->next;
      continue;
    }
    if (mp->proc.link != NULL)
      ((void(*)(menu_rec *mp, void *_link))mp->proc.proc)(mp, mp->proc.link);
    else
      ((void(*)(menu_rec *mp))mp->proc.proc)(mp);
    mp = NULL;
    menu_show();
  }
  return Result;
}


Static void trackit(void)
{
  m_tablet_info t;
  menu_head *WITH;

  quit = false;
  do {
    do {
      m_trackpen(&t);
    } while (!t.dn);
    if (!menu_check(t.x, t.y)) {
      WITH = menu_curr;
      if (WITH->modenum < 0) {
	if (menu_curr->tproc.link != NULL)
	  ((void(*)(long x, long y, void *_link))menu_curr->tproc.proc)(t.x,
	    t.y, menu_curr->tproc.link);
	else
	  ((void(*)(long x, long y))menu_curr->tproc.proc)(t.x, t.y);
      } else {
	if (menu_curr->t2proc.link != NULL)
	  ((void(*)(long x, long y, short modenum, Char *modename,
		    void *_link))menu_curr->t2proc.proc)(t.x, t.y,
	    WITH->modenum, WITH->modestr, menu_curr->t2proc.link);
	else
	  ((void(*)(long x, long y, short modenum, Char *modename))
	   menu_curr->t2proc.proc)(t.x, t.y, WITH->modenum, WITH->modestr);
      }
    }
  } while (!quit);
}


/* Radio button procedure */
Static void p_radio(menu_rec *mp)
{
  menu_rec *p, *WITH;

  p = menu_curr->menu;
  while (p != NULL) {   /* Turn off all radio buttons */
    WITH = p;
    if (mp->tag == mn_radio || mp->tag == mn_radio2)
      WITH->selected = false;
    p = WITH->next;
  }
  mp->selected = true;
  menu_curr->tproc = mp->UU.tproc;
  menu_curr->modenum = -1;
  *menu_curr->modestr = '\0';
}


/* Double-Radio button procedure */
Static void p_radio2(menu_rec *mp)
{
  menu_submoderec *WITH;

  if (mp->selected) {
    WITH = mp->UU.more;
    WITH->mode = (WITH->mode + 1) % WITH->nummodes;
/* p2c: menu.text, line 256:
 * Note: Using % for possibly-negative arguments [317] */
  }
  p_radio(mp);
  menu_curr->modenum = mp->UU.more->mode;
  strcpy(menu_curr->modestr, mp->UU.more->modes[menu_curr->modenum]);
  menu_curr->t2proc = mp->UU.more->t2proc;
}


/* Boolean toggle procedure */
Static void p_bool(menu_rec *mp)
{
  *mp->UU.boolp = !*mp->UU.boolp;
  mp->selected = *mp->UU.boolp;
}


Static menu_head *find_menu(Char *name)
{
  menu_head *Result, *p;

  Result = NULL;
  p = all_menus;
  while (p != NULL) {
    if (strcmp(p->name, name))
      p = p->next;
    else {
      Result = p;
      p = NULL;
    }
  }
  return Result;
}


Static menu_rec *find_item(menu_head *menu, Char *name)
{
  menu_rec *p, *f;

  f = NULL;
  if (menu == NULL) {
    printf("find_item: menu=NIL (name=%s)\n", name);
    return f;
  }
  p = menu->menu;
  while (p != NULL && f == NULL) {
    if (!strcmp(p->lookup, name))
      f = p;
    p = p->next;
  }
  if (f == NULL)
    printf("find_item: could not find \"%s\" in %s\n", name, menu->name);
  return f;
}


Static void change_menu(Char *newmenu_)
{
  Char newmenu[8];
  menu_head *p;

  strcpy(newmenu, newmenu_);
  p = find_menu(newmenu);
  if (p == NULL) {
    printf("Could not find menu \"%s\"\n", newmenu);
    return;
  }
  menu_prev = menu_curr;
  if (menu_curr->exit.link != NULL)
    ((void(*)(void *_link))menu_curr->exit.proc)(menu_curr->exit.link);
  else
    ((void(*)(void))menu_curr->exit.proc)();
  menu_curr = p;
  if (menu_curr->init.link != NULL)
    ((void(*)(void *_link))menu_curr->init.proc)(menu_curr->init.link);
  else
    ((void(*)(void))menu_curr->init.proc)();
  menu_erase = true;
}


/* Menu change procedure */
Static void p_menu(menu_rec *mp)
{
  change_menu(mp->UU.strp);
}


Static void add_radio(Char *name, short color, _PROCEDURE tproc)
{
  menu_rec *p;
  _PROCEDURE TEMP;

  TEMP.proc = p_radio;
  TEMP.link = NULL;
  p = menu_add(name, mn_radio, color, TEMP);
  p->UU.tproc = tproc;
}


Static void add_radio2(Char *name, short color, _PROCEDURE t2proc,
		       short nummodes, Char (*modes)[8])
{
  /* Tablet/submode proc */
  /* How many alternate modes */
  /* Array of names */
  menu_rec *p;
  _PROCEDURE TEMP;

  TEMP.proc = p_radio2;
  TEMP.link = NULL;
  p = menu_add(name, mn_radio2, color, TEMP);
  p->UU.more = Malloc(sizeof(menu_submoderec));
  p->UU.more->t2proc = t2proc;
  p->UU.more->mode = 0;
  p->UU.more->nummodes = nummodes;
  p->UU.more->modes = modes;
}


Static void add_bool(Char *name, short color, boolean *boolvar)
{
  menu_rec *p;
  _PROCEDURE TEMP;

  TEMP.proc = p_bool;
  TEMP.link = NULL;
  p = menu_add(name, mn_bool, color, TEMP);
  p->UU.boolp = boolvar;
}


/* Layers display toggle procedure */
Static void p_display(menu_rec *mp)
{
  *mp->UU.boolp = !*mp->UU.boolp;
  mp->selected = *mp->UU.boolp;
  printf("LAYERS-REFRESH!!!\n");
}


Static void add_display(Char *name, short color)
{
  menu_rec *p;
  _PROCEDURE TEMP;

  TEMP.proc = p_display;
  TEMP.link = NULL;
  p = menu_add(name, mn_bool, color, TEMP);
  p->UU.boolp = &layers_on[menu_pos];
}


Static void p_layer(menu_rec *mp)
{
  menu_rec *p, *WITH;

  p = menu_curr->menu;
  while (p != NULL) {
    WITH = p;
    if (WITH->tag == mn_layer)
      WITH->selected = false;
    p = WITH->next;
  }
  mp->selected = true;
  curr_layer = mp->UU.layer;
  if (menu_prev == NULL || !strcmp(menu_prev->name, "Main")) {
    menu_press(find_item(find_menu("Build"), "ADD"));
    change_menu("Build");
  } else
    change_menu(menu_prev->name);
}


Static void add_mlayer(Char *name, short color, short layer)
{
  menu_rec *p;
  _PROCEDURE TEMP;

  TEMP.proc = p_layer;
  TEMP.link = NULL;
  p = menu_add(name, mn_layer, color, TEMP);
  p->UU.layer = layer;
}


Static void p_action(menu_rec *mp)
{
  if (mp->UU.aproc.link != NULL)
    ((void(*)(void *_link))mp->UU.aproc.proc)(mp->UU.aproc.link);
  else
    ((void(*)(void))mp->UU.aproc.proc)();
}


Static void add_action(Char *name, short color, _PROCEDURE proc)
{
  menu_rec *p;
  _PROCEDURE TEMP;

  TEMP.proc = p_action;
  TEMP.link = NULL;
  p = menu_add(name, mn_action, color, TEMP);
  p->UU.aproc = proc;
}


Static void add_menuchange(Char *name, Char *newmenu)
{
  menu_rec *p;
  _PROCEDURE TEMP;

  TEMP.proc = p_menu;
  TEMP.link = NULL;
  p = menu_add(name, mn_change, 1, TEMP);
  p->UU.strp = Malloc(8);
  strcpy(p->UU.strp, newmenu);
}


Static void add_menuchangeVar(Char *name, Char *newmenu)
{
  menu_rec *p;
  _PROCEDURE TEMP;

  TEMP.proc = p_menu;
  TEMP.link = NULL;
  p = menu_add(name, mn_change, 1, TEMP);
  p->UU.strp = newmenu;
}


Static void do_nothing(void)
{
  printf("Nothing here \n");
}


Static void do_add(void)
{
  printf("ADD!!!\n");
}


Static void do_append(void)
{
  printf("APPEND!!!\n");
}


Static void do_clear(void)
{
  printf("CLEAR!!!\n");
}


Static void do_cnfg(void)
{
  printf("CNFG!!!\n");
}


Static void do_data(void)
{
  printf("DATA!!!\n");
}


Static void do_dir(void)
{
  printf("DIR!!!\n");
}


Static void do_dump(void)
{
  printf("DUMP!!!\n");
}


Static void do_erase(void)
{
  printf("ERASE!!!\n");
}


Static void do_list(void)
{
  printf("LIST!!!\n");
}


Static void do_load(void)
{
  printf("LOAD!!!\n");
}


Static void do_make(void)
{
  printf("MAKE!!!\n");
}


Static void do_mem(void)
{
  printf("MEM!!!\n");
}


Static void do_names(void)
{
  printf("NAMES!!!\n");
}


Static void do_new(void)
{
  printf("NEW!!!\n");
}


Static void do_opts(void)
{
  printf("OPTS!!!\n");
}


Static void do_plot(void)
{
  printf("PLOT!!!\n");
}


Static void do_save(void)
{
  printf("SAVE!!!\n");
}


Static void do_strch(void)
{
  printf("STRTCH!!!\n");
}


Static void do_scroll(void)
{
  printf("SCROLL!!!\n");
}


Static void do_tech(void)
{
  printf("TECH!!!\n");
}


Static void do_undel(void)
{
  printf("UNDELETE!!!\n");
}


Static void do_zoom(void)
{
  printf("ZOOM!!!\n");
}


Static void do_edit(void)
{
  printf("EDIT!!!\n");
}


Static void do_top(void)
{
  printf("TOP!!!\n");
}


Static void do_bott(void)
{
  printf("BOTT!!!\n");
}


Static void do_width(void)
{
  printf("WIDTH!!!\n");
}


Static void do_debug_geom(void)
{
  printf("DEBUG-GEOM!!!\n");
}


Static void do_debug_gcell(void)
{
  printf("DEBUG-GCELL!!!\n");
}


Static void do_debug_ccell(void)
{
  printf("DEBUG-CCELL!!!\n");
}


Static void do_debug_comp(void)
{
  printf("DEBUG-COMP!!!\n");
}


Static void do_debug_emerg(void)
{
  printf("DEBUG-EMERG!!!\n");
}


Static void do_debug_opts(void)
{
  printf("DEBUG-OPTS!!!\n");
}


Static void do_debug_make(void)
{
  printf("DEBUG-MAKE!!!\n");
}


Static void do_debug_wcomp(void)
{
  printf("DEBUG-WCOMP!!!\n");
}


Static void do_debug_flush(void)
{
  printf("DEBUG-FLUSH!!!\n");
}



Static void do_exit(void)
{
  printf("Exiting...\n");
  _Escape(-1);
}


Static void add_blank(void)
{
  _PROCEDURE TEMP;

  TEMP.proc = do_nothing;
  TEMP.link = NULL;
  add_action("", 0, TEMP);
}


Static void mp_ignore(long x, long y)
{
  printf("Ignored pen press at %ld,%ld\n", x, y);
}


Static void mp_exitdisp(long x, long y)
{
  change_menu(menu_prev->name);
  menu_show();
}


Static void mp_noinit(void)
{
  printf("Initializing \"%s\"\n", menu_curr->name);
}


Static void mp_initcomp(void)
{
  printf("Comp-Initializing \"%s\"\n", menu_curr->name);
  printf("Check if we are in the comp-buffer\n");
  strcpy(comp_menu, menu_curr->name);
}


Static void mp_initgeom(void)
{
  printf("Geom-Initializing \"%s\"\n", menu_curr->name);
  printf("Check if we are in the geom-buffer\n");
}


Static void mp_noexit(void)
{
  printf("Exiting \"%s\"\n", menu_curr->name);
}


Static void build_add(long x, long y)
{
  printf("Build-Add at %ld,%ld\n", x, y);
}


Static void build_move(long x, long y, short modenum, Char *modename)
{
  printf("Build-Move (%d=%s) at %ld,%ld\n", modenum, modename, x, y);
}


Static void build_delete(long x, long y, short modenum, Char *modename)
{
  printf("Build-Delete (%d=%s) at %ld,%ld\n", modenum, modename, x, y);
}


Static void build_copy(long x, long y, short modenum, Char *modename)
{
  printf("Build-Copy (%d=%s) at %ld,%ld\n", modenum, modename, x, y);
}


Static void build_edit(long x, long y)
{
  printf("Build-Edit at %ld,%ld\n", x, y);
}


Static void comp_move(long x, long y)
{
  printf("Comp-Move at %ld,%ld\n", x, y);
}


Static void comp_delete(long x, long y)
{
  printf("Comp-Delete at %ld,%ld\n", x, y);
}


Static void comp_copy(long x, long y)
{
  printf("Comp-Copy at %ld,%ld\n", x, y);
}


Static void comp2_xform(long x, long y, short modenum, Char *modename)
{
  printf("Comp2-Xform at (%d=%s) %ld,%ld\n", modenum, modename, x, y);
}


Static void elec_elec(long x, long y)
{
  printf("Elec-Elec at %ld,%ld\n", x, y);
}


Static void elec_xform(long x, long y, short modenum, Char *modename)
{
  printf("Elec-Xform at (%d=%s) %ld,%ld\n", modenum, modename, x, y);
}


Static void elec_ruler(long x, long y)
{
  printf("Elec-Ruler at %ld,%ld\n", x, y);
}


Static void elec_strch(long x, long y)
{
  printf("Elec-Strch at %ld,%ld\n", x, y);
}


Static void elec_port(long x, long y)
{
  printf("Elec-Port at %ld,%ld\n", x, y);
}


Static void poke_ruler(long x, long y)
{
  printf("Poke-Ruler at %ld,%ld\n", x, y);
}


Static void poke_poke(long x, long y)
{
  printf("Poke-Poke at %ld,%ld\n", x, y);
}


Static void draw_draw(long x, long y)
{
  printf("Draw-Draw at %ld,%ld\n", x, y);
}


Static void draw_delete(long x, long y)
{
  printf("Draw-Delete at %ld,%ld\n", x, y);
}


Static void draw_edit(long x, long y)
{
  printf("Draw-Edit at %ld,%ld\n", x, y);
}


Static void draw_ruler(long x, long y)
{
  printf("Draw-Ruler at %ld,%ld\n", x, y);
}


typedef Char btype[3][8];
typedef Char xfctype[8][8];
typedef Char xfetype[4][8];


const btype bconst = {
  "ALL", "ONE", "SEL"
};

const xfctype xfcconst = {
  "0", "R90", "R180", "R270", "M0", "M90", "M180", "M270"
};

const xfetype xfeconst = {
  "M270", "R180", "M0", "M180"
};


Static void menu_setup(void)
{
  menu_rec *p;
  _PROCEDURE TEMP;
  _PROCEDURE TEMP1;
  _PROCEDURE TEMP2;

  TEMP.proc = mp_ignore;
  TEMP.link = NULL;
  TEMP1.proc = mp_noinit;
  TEMP1.link = NULL;
  TEMP2.proc = mp_noexit;
  TEMP2.link = NULL;
  new_menu("Main", TEMP, TEMP1, TEMP2);
  add_menuchange("LAYER", "Layers");
  add_menuchange("BUILD", "Build");
  add_menuchange("ELEC", "Elec");
  add_menuchange("CELL", "Cell");
  add_menuchangeVar("COMP", comp_menu);
  strcpy(comp_menu, "Comp1");
  add_menuchange("OPTS", "Opts");
  add_blank();
  add_blank();
  add_menuchange("debug", "Debug");
  TEMP.proc = do_exit;
  TEMP.link = NULL;
  add_action("EXIT", 1, TEMP);

  TEMP.proc = mp_ignore;
  TEMP.link = NULL;
  TEMP1.proc = mp_initgeom;
  TEMP1.link = NULL;
  TEMP2.proc = mp_noexit;
  TEMP2.link = NULL;
  new_menu("Build", TEMP, TEMP1, TEMP2);
  TEMP.proc = build_add;
  TEMP.link = NULL;
  add_radio("ADD", 7, TEMP);
  TEMP.proc = build_move;
  TEMP.link = NULL;
  add_radio2("MOVE", 7, TEMP, 3, bconst);
  TEMP.proc = build_delete;
  TEMP.link = NULL;
  add_radio2("DEL", 7, TEMP, 3, bconst);
  TEMP.proc = build_copy;
  TEMP.link = NULL;
  add_radio2("COPY", 7, TEMP, 3, bconst);
  TEMP.proc = build_edit;
  TEMP.link = NULL;
  add_radio("EDIT", 7, TEMP);
  TEMP.proc = do_undel;
  TEMP.link = NULL;
  add_action("UNDEL", 7, TEMP);
  TEMP.proc = do_zoom;
  TEMP.link = NULL;
  add_action("ZOOM", 7, TEMP);
  TEMP.proc = do_make;
  TEMP.link = NULL;
  add_action("MAKE", 7, TEMP);
  add_menuchange("LAYER", "Layers");
  add_menuchange("MAIN", "Main");
  menu_press(find_item(menu_curr, "ADD"));

  TEMP.proc = mp_ignore;
  TEMP.link = NULL;
  TEMP1.proc = mp_noinit;
  TEMP1.link = NULL;
  TEMP2.proc = mp_noexit;
  TEMP2.link = NULL;
  new_menu("Layers", TEMP, TEMP1, TEMP2);
  add_mlayer("Poly", 1, 1);
  add_mlayer("Wanna", 2, 2);
  add_mlayer("Cracker", 4, 3);
  add_mlayer("Diff", 3, 4);
  add_mlayer("Cut", 7, 5);
  add_mlayer("Metal2", 15, 6);
  add_mlayer("Via", 7, 7);
  add_mlayer("Boolean", 6, 8);
  add_mlayer("Whoopee", 14, 9);
  add_menuchange("MAIN", "Main");
  /* Warning, the next line must be executed after the build menu is defined */
  menu_press(find_item(menu_curr, "Poly"));

  TEMP.proc = mp_ignore;
  TEMP.link = NULL;
  TEMP1.proc = mp_initgeom;
  TEMP1.link = NULL;
  TEMP2.proc = mp_noexit;
  TEMP2.link = NULL;
  new_menu("Cell", TEMP, TEMP1, TEMP2);
  TEMP.proc = do_make;
  TEMP.link = NULL;
  add_action("MAKE", 7, TEMP);
  TEMP.proc = do_list;
  TEMP.link = NULL;
  add_action("LIST", 7, TEMP);
  TEMP.proc = do_append;
  TEMP.link = NULL;
  add_action("APPEND", 7, TEMP);
  TEMP.proc = do_new;
  TEMP.link = NULL;
  add_action("NEW", 7, TEMP);
  TEMP.proc = do_erase;
  TEMP.link = NULL;
  add_action("ERASE", 7, TEMP);
  TEMP.proc = do_clear;
  TEMP.link = NULL;
  add_action("CLEAR", 7, TEMP);
  TEMP.proc = do_plot;
  TEMP.link = NULL;
  add_action("PLOT", 7, TEMP);
  TEMP.proc = do_zoom;
  TEMP.link = NULL;
  add_action("ZOOM", 7, TEMP);
  add_menuchange("BUILD", "Build");
  add_menuchange("MAIN", "Main");

  TEMP.proc = mp_ignore;
  TEMP.link = NULL;
  TEMP1.proc = mp_initgeom;
  TEMP1.link = NULL;
  TEMP2.proc = mp_noexit;
  TEMP2.link = NULL;
  new_menu("Elec", TEMP, TEMP1, TEMP2);
  TEMP.proc = elec_elec;
  TEMP.link = NULL;
  add_radio("ELEC", 7, TEMP);
  TEMP.proc = elec_xform;
  TEMP.link = NULL;
  add_radio2("XFORM", 7, TEMP, 4, xfeconst);
  TEMP.proc = elec_ruler;
  TEMP.link = NULL;
  add_radio("RULER", 7, TEMP);
  TEMP.proc = elec_strch;
  TEMP.link = NULL;
  add_radio("strch", 7, TEMP);
  TEMP.proc = elec_port;
  TEMP.link = NULL;
  add_radio("port", 7, TEMP);
  TEMP.proc = do_data;
  TEMP.link = NULL;
  add_action("data", 7, TEMP);
  add_blank();
  add_blank();
  add_menuchange("Build", "Build");
  add_menuchange("MAIN", "Main");
  menu_press(find_item(menu_curr, "RULER"));

  TEMP.proc = mp_ignore;
  TEMP.link = NULL;
  TEMP1.proc = mp_initcomp;
  TEMP1.link = NULL;
  TEMP2.proc = mp_noexit;
  TEMP2.link = NULL;
  new_menu("Comp1", TEMP, TEMP1, TEMP2);
  TEMP.proc = do_add;
  TEMP.link = NULL;
  add_action("ADD", 7, TEMP);
  TEMP.proc = comp_move;
  TEMP.link = NULL;
  add_radio("MOVE", 7, TEMP);
  TEMP.proc = comp_delete;
  TEMP.link = NULL;
  add_radio("DEL", 7, TEMP);
  TEMP.proc = comp_copy;
  TEMP.link = NULL;
  add_radio("COPY", 7, TEMP);
  add_menuchange("POKE", "Poke");
  TEMP.proc = do_make;
  TEMP.link = NULL;
  add_action("MAKE", 7, TEMP);
  add_menuchange("draw", "Draw");
  TEMP.proc = do_new;
  TEMP.link = NULL;
  add_action("NEW", 7, TEMP);
  add_menuchange("OTHER", "Comp2");
  add_menuchange("MAIN", "Main");
  menu_press(find_item(menu_curr, "MOVE"));

  TEMP.proc = mp_ignore;
  TEMP.link = NULL;
  TEMP1.proc = mp_initcomp;
  TEMP1.link = NULL;
  TEMP2.proc = mp_noexit;
  TEMP2.link = NULL;
  new_menu("Comp2", TEMP, TEMP1, TEMP2);
  TEMP.proc = comp2_xform;
  TEMP.link = NULL;
  add_radio2("XFORM", 7, TEMP, 8, xfcconst);
  TEMP.proc = do_erase;
  TEMP.link = NULL;
  add_action("ERASE", 7, TEMP);
  TEMP.proc = do_clear;
  TEMP.link = NULL;
  add_action("CLEAR", 7, TEMP);
  TEMP.proc = do_zoom;
  TEMP.link = NULL;
  add_action("ZOOM", 7, TEMP);
  TEMP.proc = do_scroll;
  TEMP.link = NULL;
  add_action("SCROLL", 7, TEMP);
  TEMP.proc = do_names;
  TEMP.link = NULL;
  add_action("NAMES", 7, TEMP);
  TEMP.proc = do_list;
  TEMP.link = NULL;
  add_action("LIST", 7, TEMP);
  TEMP.proc = do_plot;
  TEMP.link = NULL;
  add_action("PLOT", 7, TEMP);
  add_menuchange("OTHER", "Comp1");
  add_menuchange("MAIN", "Main");
  menu_press(find_item(menu_curr, "XFORM"));

  TEMP.proc = mp_ignore;
  TEMP.link = NULL;
  TEMP1.proc = mp_noinit;
  TEMP1.link = NULL;
  TEMP2.proc = mp_noexit;
  TEMP2.link = NULL;
  new_menu("Opts", TEMP, TEMP1, TEMP2);
  TEMP.proc = do_load;
  TEMP.link = NULL;
  add_action("LOAD", 7, TEMP);
  TEMP.proc = do_save;
  TEMP.link = NULL;
  add_action("SAVE", 7, TEMP);
  add_bool("BBOX", 7, &gbool);
  TEMP.proc = do_mem;
  TEMP.link = NULL;
  add_action("MEM", 7, TEMP);
  TEMP.proc = do_dir;
  TEMP.link = NULL;
  add_action("DIR", 7, TEMP);
  TEMP.proc = do_opts;
  TEMP.link = NULL;
  add_action("OPTS", 7, TEMP);
  TEMP.proc = do_cnfg;
  TEMP.link = NULL;
  add_action("CNFG", 7, TEMP);
  TEMP.proc = do_tech;
  TEMP.link = NULL;
  add_action("TECH", 7, TEMP);
  TEMP.proc = do_dump;
  TEMP.link = NULL;
  add_action("DUMP", 7, TEMP);
  add_menuchange("MAIN", "Main");

  TEMP.proc = mp_ignore;
  TEMP.link = NULL;
  TEMP1.proc = mp_initcomp;
  TEMP1.link = NULL;
  TEMP2.proc = mp_noexit;
  TEMP2.link = NULL;
  new_menu("Poke", TEMP, TEMP1, TEMP2);
  TEMP.proc = poke_poke;
  TEMP.link = NULL;
  add_radio("POKE", 7, TEMP);
  TEMP.proc = do_top;
  TEMP.link = NULL;
  add_action("TOP", 7, TEMP);
  TEMP.proc = do_bott;
  TEMP.link = NULL;
  add_action("BOTT", 7, TEMP);
  TEMP.proc = poke_ruler;
  TEMP.link = NULL;
  add_radio("RULER", 7, TEMP);
  TEMP.proc = do_plot;
  TEMP.link = NULL;
  add_action("PLOT", 7, TEMP);
  TEMP.proc = do_edit;
  TEMP.link = NULL;
  add_action("edit", 7, TEMP);
  add_menuchange("layer", "Display");   /* Needs to be fixed!!! */
  add_blank();
  add_menuchange("COMP", "Comp1");
  add_menuchange("MAIN", "Main");
  menu_press(find_item(menu_curr, "POKE"));

  TEMP.proc = mp_ignore;
  TEMP.link = NULL;
  TEMP1.proc = mp_initcomp;
  TEMP1.link = NULL;
  TEMP2.proc = mp_noexit;
  TEMP2.link = NULL;
  new_menu("Draw", TEMP, TEMP1, TEMP2);
  TEMP.proc = draw_draw;
  TEMP.link = NULL;
  add_radio("draw", 7, TEMP);
  TEMP.proc = draw_delete;
  TEMP.link = NULL;
  add_radio("del", 7, TEMP);
  TEMP.proc = draw_edit;
  TEMP.link = NULL;
  add_radio("edit", 7, TEMP);
  add_menuchange("layer", "Layers");
  TEMP.proc = do_width;
  TEMP.link = NULL;
  add_action("width", 7, TEMP);
  TEMP.proc = draw_ruler;
  TEMP.link = NULL;
  add_radio("RULER", 7, TEMP);
  add_blank();
  add_blank();
  add_menuchange("COMP", "Comp1");
  add_menuchange("MAIN", "Main");
  menu_press(find_item(menu_curr, "draw"));

  TEMP.proc = mp_ignore;
  TEMP.link = NULL;
  TEMP1.proc = mp_noinit;
  TEMP1.link = NULL;
  TEMP2.proc = mp_noexit;
  TEMP2.link = NULL;
  new_menu("Debug", TEMP, TEMP1, TEMP2);
  TEMP.proc = do_debug_geom;
  TEMP.link = NULL;
  add_action("geom", 7, TEMP);
  TEMP.proc = do_debug_gcell;
  TEMP.link = NULL;
  add_action("gcell", 7, TEMP);
  TEMP.proc = do_debug_ccell;
  TEMP.link = NULL;
  add_action("ccell", 7, TEMP);
  TEMP.proc = do_debug_comp;
  TEMP.link = NULL;
  add_action("comp", 7, TEMP);
  TEMP.proc = do_debug_emerg;
  TEMP.link = NULL;
  add_action("emerg", 7, TEMP);
  TEMP.proc = do_debug_opts;
  TEMP.link = NULL;
  add_action("OPTS", 7, TEMP);
  TEMP.proc = do_debug_make;
  TEMP.link = NULL;
  add_action("make", 7, TEMP);
  TEMP.proc = do_debug_wcomp;
  TEMP.link = NULL;
  add_action("wcomp", 7, TEMP);
  TEMP.proc = do_debug_flush;
  TEMP.link = NULL;
  add_action("flush", 7, TEMP);
  add_menuchange("MAIN", "Main");

  TEMP.proc = mp_exitdisp;
  TEMP.link = NULL;
  TEMP1.proc = mp_initcomp;
  TEMP1.link = NULL;
  TEMP2.proc = mp_noexit;
  TEMP2.link = NULL;
  new_menu("Display", TEMP, TEMP1, TEMP2);
  add_display("Poly", 1);
  add_display("Wanna", 2);
  add_display("Cracker", 4);
  add_display("Diff", 3);
  add_display("Cut", 7);
  add_display("Metal2", 15);
  add_display("Via", 7);
  add_display("Boolean", 6);
  add_display("Whoopee", 14);
  add_display("Nolayer", 13);
}


Static void init(void)
{
  all_menus = NULL;
  menu_curr = NULL;

  m_init_graphics();
  m_choosefont(1);
}


Static void main_(void)
{
  init();
  menu_setup();
  while (!quit) {
    TRY(try1);
      menu_curr = find_menu("Main");
      menu_show();
      trackit();
    RECOVER(try1);
      misc_printerror(P_escapecode, P_ioresult);
      quit = false;
      menu_erase = true;
    ENDTRY(try1);
  }
}


main(int argc, Char *argv[])
{
  PASCAL_MAIN(argc, argv);
  main_();
  exit(0);
}



/* End. */
