
/* "WOL", an integrated circuit layout tool,
   Copyright (C) 1983, 1990 California Institute of Technology.
   Author: Massimo Sivilotti
   Thanks to: Glenn Gribble, Marty Sirkin, Sylvie Rychebusch
	      Maryann Mayer, Carver Mead, Rick Koshi, Torre Lande
   Maintainer: John Lazzaro
   Maintainers's address: lazzaro@hobiecat.cs.caltech.edu;
                          CB 425/ CU Boulder/Boulder CO 91125. 
			  Send questions, bug fixes, to this address.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (Version 1, 1989).

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* Output from p2c, the Pascal-to-C translator */
/* p2c: wolopt.text, line 9: Note: Range checking is OFF [216] */
/* p2c: wolopt.text, line 10: Note: Stack checking is OFF [217] */
/* p2c: wolopt.text, line 16: Note: Range checking is ON [216] */
/* From input file "mess_stuff.text" */


/* Change these for testing */



#include "global.h"


#define MESSAGE_STUFF_G
#include "message_stuff.h"


void geterrmsg(Char *s)
{
  extern long EXCP_LINE;
  long r;
  Char STR2[256];

  s[0] = '\0';
  if (P_escapecode > 0) {
    sprintf(s, "Halt code = %d", P_escapecode);
    r = strlen(s) + 1;
  } else {
    switch (P_escapecode) {

    case 0:
      strcpy(s, "normal termination");
      break;

    case -1:
      strcpy(s, "abnormal termination");
      break;

    case -2:
      strcpy(s, "not enough memory");
      break;

    case -3:
      strcpy(s, "reference to NIL pointer");
      break;

    case -4:
      strcpy(s, "integer overflow");
      break;

    case -5:
      strcpy(s, "divide by zero");
      break;

    case -6:
      strcpy(s, "real math overflow");
      break;

    case -7:
      strcpy(s, "real math underflow");
      break;

    case -8:
      strcpy(s, "value range error");
      break;

    case -9:
      strcpy(s, "case value range error");
      break;

    case -10:
      misc_getioerrmsg(s, P_ioresult);
      break;

    case -11:
      strcpy(s, "CPU word access to odd address");
      break;

    case -12:
      strcpy(s, "CPU buss error");
      break;

    case -13:
      strcpy(s, "illegal CPU instruction");
      break;

    case -14:
      strcpy(s, "CPU privilege violation");
      break;

    case -15:
      strcpy(s, "bad argument: SIN/COS");
      break;

    case -16:
      strcpy(s, "bad argument: LN");
      break;

    case -17:
      strcpy(s, "bad argument: SQRT");
      break;

    case -18:
      strcpy(s, "bad argument: real/BCD conversion");
      break;

    case -19:
      strcpy(s, "bad argument: BCD/real conversion");
      break;

    case -20:
      strcpy(s, "stopped by user");
      break;

    case -22:
      strcpy(s, "call to debugger (-21)");
      break;

    case -23:
      strcpy(s, "??????????? (-22)");
      break;

    case -24:
      strcpy(s, "macro parameter not 0..9 or A..Z");
      break;

    case -25:
      strcpy(s, "undefined macro parameter");
      break;

    case -26:
      sprintf(s, "I/O routine error: %s on %ld",
	      ioerror_message(STR2, ioe_result), ioe_isc);
      r = strlen(s) + 1;
      break;

    case -27:
      strcpy(s, "graphics routine error");
      break;

    case -28:
      strcpy(s, "floating point error???");
      break;

    default:
      sprintf(s, "Undocumented error (%d)", P_escapecode);
      r = strlen(s) + 1;
      break;
    }/* case */
  }
  if (EXCP_LINE != -1) {
    sprintf(s + strlen(s), " @ line %ld", EXCP_LINE);
    r = strlen(s) + 1;
  }
}


/* Routine to display a random message on the screen */
void show_message(Char *mess, boolean clearit)
{
  if (clearit && strcmp(m_machine, "320"))
    alpha_screen(CLR);
  if (YPOS < 2)   /* enforce cursor position */
    YPOS = 2;
  if (XPOS > 0)
    putchar('\n');
  m_alpha_on();
  /*m_graphics_on;# ###???- maybe should do something */
  puts(mess);
}


/* Routine to display error messages on the screen.  Assumes that IORESULT */
/* and ESCAPECODE have not been changed since last escape error.  Special  */
/* escapecode 10 implies internal escape, just print extra.                */
/*                                                                         */
void show_error(Char *extra, boolean clearit)
{
  Char err[81];
  long e, i;

  e = P_escapecode;   /* save error variables */
  i = P_ioresult;
  if (P_escapecode == 10)
    err[0] = '\0';
  else
    geterrmsg(err);
  if (clearit)   /*write(#L);*/
    alpha_screen(CLR);
  if (YPOS < 2)   /* enforce cursor position */
    YPOS = 2;
  if (XPOS > 0)
    putchar('\n');
  m_alpha_on();
  m_graphics_off();
  printf("%s: %s\n", extra, err);
  P_ioresult = i;   /* restore error variables */
  P_escapecode = e;
}


/* module MESSAGE_STUFF */




/* End. */
