
/* "WOL", an integrated circuit layout tool,
   Copyright (C) 1983, 1990 California Institute of Technology.
   Author: Massimo Sivilotti
   Thanks to: Glenn Gribble, Marty Sirkin, Sylvie Rychebusch
	      Maryann Mayer, Carver Mead, Rick Koshi, Torre Lande
   Maintainer: John Lazzaro
   Maintainers's address: lazzaro@hobiecat.cs.caltech.edu;
                          CB 425/ CU Boulder/Boulder CO 91125. 
			  Send questions, bug fixes, to this address.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (Version 1, 1989).

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* Output from p2c, the Pascal-to-C translator */
/* p2c: rpl.text, line 3: Note: Range checking is OFF [216] */
/* p2c: rpl.text, line 3: Note: Overflow checking is OFF [219] */
/* From input file "rpl.text" */


/* Identifier replacer -- from Glenn Gribble */


#include "global.h"


#ifndef NEWCI_H
#include <p2c/newci.h>
#endif


#define max             200


typedef Char foobar[max][81];


Static long num;
Static Char (*src)[81], (*dst)[81];


/*   warn:packed array[1..max] of boolean;   */

Static void ucase(Char *s)
{
  long i, FORLIM;

  FORLIM = strlen(s);
  for (i = 0; i < FORLIM; i++) {
    if (islower(s[i]))
      s[i] -= 32;
  }
}


Static void setup(void)
{
  FILE *t;
  Char s[256];
  long i;
  Char *TEMP;
  Char STR1[256], STR2[256];

  t = NULL;
  if (t != NULL)
    t = freopen("RPL.SRC", "r", t);
  else
    t = fopen("RPL.SRC", "r");
  if (t == NULL)
    _EscIO(FileNotFound);
  num = 1;
  while (fgets(s, 256, t) != NULL) {
    TEMP = strchr(s, '\n');
    if (TEMP != NULL)
      *TEMP = 0;
    strcpy(STR1, strltrim(strrtrim(strcpy(STR2, s))));
    strcpy(s, STR1);
    i = strpos2(s, " ", 1);
    if (!(i != 0 && (s[0] == '_' || isalnum(s[0])))) {
      if (*s != '\0')
	printf("Error in RPL.SRC: %s\n", s);
      continue;
    }
    sprintf(src[num - 1], "%.*s", (int)(i - 1), s);
    /*   if src^[num][1] = '*' then
          begin
             strdelete(src^[num], 1, 1);
             warn[num] := true;
          end
       else
          warn[num] := false;      */
    strcpy(s, s + i);
    strcpy(dst[num - 1], strltrim(s));
    fprintf(stderr, "%s==>%s\n", src[num - 1], dst[num - 1]);
    ucase(src[num - 1]);
    num++;
  }
  num--;
  if (t != NULL)
    fclose(t);
}


Static void replaceit(void)
{
  Char s[256], s2[256], t[256];
  long i, j, eos;
  boolean quoted, comment;
  long FORLIM;
  Char STR1[256];

  comment = false;
  while (!P_eof(stdin)) {
    gets(s);
    strcpy(s2, s);
    ucase(s2);
    t[0] = '\0';
    j = 1;
    quoted = false;
    while (j <= strlen(s2)) {
      if (!quoted && !comment &&
	  (j == 1 ||
	   !(s2[j - 2] == '_' || isupper(s2[j - 2]) || isdigit(s2[j - 2]))) &&
	  (s2[j - 1] == '_' || isupper(s2[j - 1]) || isdigit(s2[j - 1]))) {
	FORLIM = num;
	for (i = 0; i < FORLIM; i++) {
	  eos = j + strlen(src[i]) - 1;
	  if (eos <= strlen(s2) &&
	      !strcmp((sprintf(STR1, "%.*s", strlen(src[i]), s2 + j - 1),
		       STR1), src[i]) &&
	      (eos == strlen(s2) ||
	       !(s2[eos] == '_' || isupper(s2[eos]) || isdigit(s2[eos])))) {
	    fprintf(stderr, "%s==>%s\n", src[i], dst[i]);
	    j = eos + 1;
	    strcat(t, dst[i]);
	    goto _L1;
	  }
	}
      }
      if (s[j - 1] == '\'')
	quoted = !quoted;
      else if (!quoted) {
	if (s[j - 1] == '{')
	  comment = true;
	else if (s[j - 1] == '}')
	  comment = false;
      }
      sprintf(t + strlen(t), "%.1s", s + j - 1);
      j++;
_L1: ;
    }
    puts(t);
    putc('.', stderr);
  }
}


main(int argc, Char *argv[])
{
  PASCAL_MAIN(argc, argv);
  src = Malloc(sizeof(foobar));
  dst = Malloc(sizeof(foobar));
  setup();
  replaceit();
  exit(0);
}



/* End. */
