
/* "WOL", an integrated circuit layout tool,
   Copyright (C) 1983, 1990 California Institute of Technology.
   Author: Massimo Sivilotti
   Thanks to: Glenn Gribble, Marty Sirkin, Sylvie Rychebusch
	      Maryann Mayer, Carver Mead, Rick Koshi, Torre Lande
   Maintainer: John Lazzaro
   Maintainers's address: lazzaro@hobiecat.cs.caltech.edu;
                          CB 425/ CU Boulder/Boulder CO 91125. 
			  Send questions, bug fixes, to this address.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (Version 1, 1989).

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* Output from p2c, the Pascal-to-C translator */
/* p2c: wolopt.text, line 9: Note: Range checking is OFF [216] */
/* p2c: wolopt.text, line 10: Note: Stack checking is OFF [217] */
/* p2c: wolopt.text, line 16: Note: Range checking is ON [216] */
/* From input file "tab_stuff.text" */


/* Change these for testing */



#include "global.h"


#define TABLET_STUFF_G
#include "tablet_stuff.h"


#ifndef NEWTABLET_H
#include <p2c/newtablet.h>
#endif


Static long tb_offx, tb_offy, tb_height, tb_width;   /* of tablet */


/*******************************************************************************/

tablet_info check_pen(void)
{
  tablet_info t;

  if (check_pen_proc.link != NULL)
    ((void(*)(tablet_info *t, void *_link))check_pen_proc.proc)(&t,
      check_pen_proc.link);
  else
    ((void(*)(tablet_info *t))check_pen_proc.proc)(&t);
  return t;
}


/*******************************************************************************/

void tablet_reset(void)
{
  Char s[21];
  long xl, yl, xh, yh;

  if (!nt_init(0))
    printf("\007WARNING: No tablet found.\n");
  nt_info(s, &xl, &yl, &xh, &yh);
  tb_offx = xl;
  tb_offy = yl;
  tb_width = xh - xl;
  tb_height = yh - yl;
  if (tb_width == 0)   /* If no tablet found. */
    tb_width = 1000;
  if (tb_height == 0)
    tb_height = 1000;
}


/* size of screen */

#define xl              0
#define yb              0


/*******************************************************************************/

tablet_info get_pen(void)
{
  tablet_info tablet;
  short xr, yt;
  m_tablet_info mylib_tablet;

  xr = RIGHT_OF_SCREEN;
  yt = MAX_TOP_OF_SCREEN;

  m_readpen(&mylib_tablet);
  tablet.x = mylib_tablet.x;
  tablet.y = mylib_tablet.y;
  tablet.depressed = mylib_tablet.depressed;
  tablet.near_ = mylib_tablet.near_;
  tablet.menu = 0;
  /* clip the values */
  if (tablet.x < xl)
    tablet.x = xl;
  else if (tablet.x > xr)
    tablet.x = xr;
  if (tablet.y < yb)
    tablet.y = yb;
  else if (tablet.y > yt)
    tablet.y = yt;

  /* convert from tablet to alpha-screen */
  tablet.ax = mylib_tablet.ax;
  tablet.ay = mylib_tablet.ay;

  return tablet;
  /* with tablet do writeln('+',x:1,',',y:1,',',status:1); */
}  /* get_pen */

#undef xl
#undef yb


/*******************************************************************************/

void debounce(void)
{
  /* Waits for pen to be raised before returning */
  while (get_pen().depressed) ;
}


/*******************************************************************************/

tablet_info get_pena(void)
{
  tablet_info ti;

  ti = get_pen();
  /* copy alpha to graphic coordinates */
  ti.x = ti.ax;
  ti.y = ti.ay;
  return ti;
}


/* Wait until pen pressed, or key pressed. */
/* Returns #0 if pen, key if keyboard. */
Char wait_pen_or_kbd(void)
{
  tablet_info ti;
  boolean down;

  ti.depressed = true;
  do {
    down = ti.depressed;
    ti = get_pen();
  } while (nk_keybufsize() <= 0 && (!ti.depressed || down));
  if (nk_keybufsize() > 0)
    return (nk_getkey());
  else
    return '\0';
}


/* of module TABLET_STUFF */




/* End. */
