/* Header for module tablet_stuff, generated by p2c */
#ifndef TABLET_STUFF_H
#define TABLET_STUFF_H


/* Lots of the tablet stuff. */

#ifndef SYSGLOBALS_H
#include <p2c/sysglobals.h>
#endif

#ifndef GENERAL_1_H
#include <p2c/general_1.h>
#endif

#ifndef GENERAL_2_H
#include <p2c/general_2.h>
#endif

#ifndef HPIB_1_H
#include <p2c/hpib_1.h>
#endif

#ifndef HPIB_2_H
#include <p2c/hpib_2.h>
#endif

#ifndef NEWKBD_H
#include <p2c/newkbd.h>
#endif

#ifndef MYLIB_H
#include <p2c/mylib.h>
#endif

#ifndef WOL_GRAPHICS_H
#include "wol_graphics.h"
#endif


#ifdef TABLET_STUFF_G
# define vextern
#else
# define vextern extern
#endif


typedef struct tablet_info {
  /* what is returned upon interogating the tablet */
  short x, y;   /* screen coordinates (alpha/graphics)  */
  short ax, ay;   /* alpha coordinates */
  boolean depressed;   /* true if pen is depressed */
  boolean near_;   /* is pen near? */
  short menu;   /* which menu item was selected (0 if none) */
  /* This is the on-screen menu, not the hardware tablet menu squares */
} tablet_info;


vextern _PROCEDURE check_pen_proc;


extern void tablet_reset(void);
/* Reset tablet... */
extern tablet_info get_pen(void);
/* In graphics coords */
extern tablet_info get_pena(void);
/* In alpha coords */
extern void debounce(void);
/* Waits for penup */
extern Char wait_pen_or_kbd(void);
extern tablet_info check_pen(void);


#undef vextern

#endif /*TABLET_STUFF_H*/

/* End. */
