
/* "WOL", an integrated circuit layout tool,
   Copyright (C) 1983, 1990 California Institute of Technology.
   Author: Massimo Sivilotti
   Thanks to: Glenn Gribble, Marty Sirkin, Sylvie Rychebusch
	      Maryann Mayer, Carver Mead, Rick Koshi, Torre Lande
   Maintainer: John Lazzaro
   Maintainers's address: lazzaro@hobiecat.cs.caltech.edu;
                          CB 425/ CU Boulder/Boulder CO 91125. 
			  Send questions, bug fixes, to this address.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (Version 1, 1989).

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* Output from p2c, the Pascal-to-C translator */
/* From input file "tanner2wol.text" */


#include "global.h"


Static Char ch;
Static Char line[256];
Static long junk;
Static boolean done;


Static void box(void)
{
  long i, FORLIM;

  gets(line);
  FORLIM = strlen(line);
  for (i = 0; i < FORLIM; i++) {
    if (line[i] == ',')
      line[i] = ' ';
  }
  printf("B%s\n", line);
}


Static void comment(void)
{
  long i, a, b, c, d, FORLIM;

  gets(line);
  if (strpos2(line, "mbb", 1) != 0) {
    printf("(MBB;\n");
    FORLIM = strlen(line);
    for (i = 3; i < FORLIM; i++) {
      if (line[i] == ',')
	line[i] = ' ';
    }
    sscanf(line + 3, "%ld%ld%ld%ld%ln", &a, &b, &c, &d, &junk);
    junk += 4;
    printf("B%ld %ld %ld %ld;);\n", c, b, c / 2, b / 2);
    return;
  }
  while (strpos2(line, ")", 1) == 0) {
    scanf("%*[^\n]");
/*    getchar();*/
    nk_getkey();
  }
}


Static void callit(void)
{
  long i, rx, ry, tx, ty, sym, FORLIM;

  scanf("%ld", &sym);
  rx = 0;
  ry = 0;
  tx = 0;
  ty = 0;
  gets(line);
  FORLIM = strlen(line);
  for (i = 0; i < FORLIM; i++) {
    if (line[i] == ',')
      line[i] = ' ';
  }
  i = 1;
  while (i <= strlen(line)) {
    if (line[i - 1] == 'T') {
      sscanf(line + i, "%ld%ld%ln", &tx, &ty, &junk);
      junk += i + 1;
    }
    if (line[i - 1] == 'R') {
      sscanf(line + i, "%ld%ld%ln", &rx, &ry, &junk);
      junk += i + 1;
    }
    i++;
  }
  printf("85 ;\n");
  if (rx == 0 && ry == 0)
    printf("C%ld T%ld %ld;\n", sym, tx, ty);
  else
    printf("C%ld R%ld %ld T%ld %ld;\n", sym, rx, ry, tx, ty);
}


main(int argc, Char *argv[])
{  /* main */
  PASCAL_MAIN(argc, argv);
  done = false;
  do {
/*    ch = getchar();*/
      ch = nk_getkey();
    if (ch == '\n')
      ch = ' ';
    switch (ch) {

    case '(':
      comment();
      break;

    case 'B':
      box();
      break;

    case 'C':
      callit();
      break;

    case 'E':
      printf("E\n");
      done = true;
      break;

    default:
      putchar(ch);
      gets(line);
      puts(line);
      break;
    }
  } while (!done);
  exit(0);
}




/* End. */
