
/* "WOL", an integrated circuit layout tool,
   Copyright (C) 1983, 1990 California Institute of Technology.
   Author: Massimo Sivilotti
   Thanks to: Glenn Gribble, Marty Sirkin, Sylvie Rychebusch
	      Maryann Mayer, Carver Mead, Rick Koshi, Torre Lande
   Maintainer: John Lazzaro
   Maintainers's address: lazzaro@hobiecat.cs.caltech.edu;
                          CB 425/ CU Boulder/Boulder CO 91125. 
			  Send questions, bug fixes, to this address.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (Version 1, 1989).

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* Output from p2c, the Pascal-to-C translator */
/* p2c: wolopt.text, line 9: Note: Range checking is OFF [216] */
/* p2c: wolopt.text, line 10: Note: Stack checking is OFF [217] */
/* p2c: wolopt.text, line 16: Note: Range checking is ON [216] */
/* From input file "timing.text" */


/* Change these for testing */



#include "global.h"


#define TIMING_G
#include "timing.h"


Static long start;


typedef Char monlist[16][4];


const monlist months = {
  "000", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct",
  "Nov", "Dec", "013", "014", "015"
};


/*******************************************************************************/

Char *get_date_string(Char *Result)
{
  long pos;
  Char ampm[4];
  datetimerec datetime;
  Char date_string[81];

  sysdate(&datetime.date);
  systime(&datetime.time);

  sprintf(date_string, "%s%3d%5d",
	  months[datetime.date.month], datetime.date.day,
	  datetime.date.year + 1900);
  pos = strlen(date_string) + 1;
  strcpy(ampm, " am");
  if (datetime.time.hour > 11) {
    datetime.time.hour -= 12;
    strcpy(ampm, " pm");
  }
  if (datetime.time.hour == 0)
    datetime.time.hour = 12;
  sprintf(date_string + pos - 1, "%3d:", datetime.time.hour);
  pos = strlen(date_string) + 1;
  if (datetime.time.minute < 10) {
    sprintf(date_string + pos - 1, "0");
    pos = strlen(date_string) + 1;
  }
  sprintf(date_string + pos - 1, "%d%s", datetime.time.minute, ampm);
  pos = strlen(date_string) + 1;
  return strcpy(Result, date_string);
}


/*******************************************************************************/
void waitfor(long centiseconds)
{
  long endtime;

  if (strcmp(m_machine, "X")) {
    endtime = sysclock() + centiseconds;
    while (endtime > sysclock()) ;
  }
}


/*******************************************************************************/

void time_start(void)
{
  start = sysclock();
}


/*******************************************************************************/

void time_end(Char *s)
{
  start = sysclock() - start;
  printf("%s: took %0.2f seconds.\n", s, start / 100.0);
  m_alpha_on();
}


long elapsed_time(void)
{  /* return time in centiseconds since time_start */
  return (sysclock() - start);
}


/* module timing */





/* End. */
