
/* "WOL", an integrated circuit layout tool,
   Copyright (C) 1983, 1990 California Institute of Technology.
   Author: Massimo Sivilotti
   Thanks to: Glenn Gribble, Marty Sirkin, Sylvie Rychebusch
	      Maryann Mayer, Carver Mead, Rick Koshi, Torre Lande
   Maintainer: John Lazzaro
   Maintainers's address: lazzaro@hobiecat.cs.caltech.edu;
                          CB 425/ CU Boulder/Boulder CO 91125. 
			  Send questions, bug fixes, to this address.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (Version 1, 1989).

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* Output from p2c, the Pascal-to-C translator */
/* From input file "wires.text" */


#include "global.h"


#ifndef MYLIB_H
#include <p2c/mylib.h>
#endif


#define np              4


Static long xx, yy, xo, yo, temp;
Static long xp[np], yp[np];
Static long xa[100], ya[100];   /* actually, 4 is enough */
Static m_tablet_info t;
Static long i, which;
Static double r, r0, pi;
Static boolean filled;


Static double dist(long x1, long y1, long x2, long y2)
{
  long TEMP1, TEMP2;

  TEMP1 = x2 - x1;
  TEMP2 = y2 - y1;
  return sqrt((double)(TEMP1 * TEMP1 + TEMP2 * TEMP2));
}


#define radius          10


Static void drawpoly(void)
{
  double r;
  long dx, dy, i;

  for (i = 1; i < np; i++) {
    r = dist(xp[i - 1], yp[i - 1], xp[i], yp[i]) / radius;
    dx = xp[i] - xp[i - 1];   /* radius = 1/2 width */
    dy = yp[i] - yp[i - 1];
    xa[0] = xp[i - 1] - (long)floor(0.5 - dy / r);   /*dx/r*/
    /* To extend wire ends */
    ya[0] = yp[i - 1] - (long)floor(dx / r + 0.5);   /*dy/r*/
    /* by 1 radius, remove */
    xa[1] = xp[i - 1] - (long)floor(dy / r + 0.5);   /*dx/r*/
    /* comment braces */
    ya[1] = yp[i - 1] - (long)floor(0.5 - dx / r);   /*dy/r*/
    xa[2] = xp[i] + (long)floor(0.5 - dy / r);   /*dx/r*/
    ya[2] = yp[i] + (long)floor(dx / r + 0.5);   /*dy/r*/
    xa[3] = xp[i] + (long)floor(dy / r + 0.5);   /*dx/r*/
    ya[3] = yp[i] + (long)floor(0.5 - dx / r);   /*dy/r*/
    m_color(m_yellow);
    if (filled)
      m_fillpoly(4, xa, ya);
    m_color(m_red);
    m_drawpoly(4, xa, ya);
    if (filled) {
      m_color(m_yellow);   /* <-- fill color   outline color */
      m_ellipse(xp[i - 1], yp[i - 1], radius, radius, m_red);
    }
  }
  /* now draw end point */
  if (filled) {
    m_color(m_yellow);   /* <-- fill color   outline color */
    m_ellipse(xp[np - 1], yp[np - 1], radius, radius, m_red);
  }

  m_color(m_blue);   /* Dots to mark wire ends -- */
  for (i = 0; i < np; i++)   /*  for testing only */
    m_drawpoint(xp[i], yp[i]);

  /*  m_color(m_red);
    for i := 1 to np do
       m_circle(xp[i], yp[i], radius);  */
  /*  m_color(m_red);
      m_circle(xp[np], yp[np], radius);  */
}

#undef radius


main(int argc, Char *argv[])
{
  PASCAL_MAIN(argc, argv);
  pi = 4 * atan(1.0);
  m_init_graphics();
  xp[0] = 100;
  yp[0] = 100;
  xp[1] = 300;
  yp[1] = 200;
  xp[2] = 200;
  yp[2] = 300;
  xp[3] = 100;
  yp[3] = 300;
  do {
    filled = true;
    m_colormode(m_normal);
    drawpoly();
    do {
      m_trackpen(&t);
    } while (!t.dn);
    r0 = 9e9;
    for (i = 1; i <= np; i++) {
      r = dist(xp[i - 1], yp[i - 1], t.x, t.y);
      if (r < r0) {
	r0 = r;
	which = i;
      }
    }
    m_colormode(m_mask);
    drawpoly();
    filled = false;
    xx = xp[which - 1];
    yy = yp[which - 1];
    xo = t.x - xp[which - 1];
    yo = t.y - yp[which - 1];
    do {
      xp[which - 1] = t.x - xo;
      yp[which - 1] = t.y - yo;
      m_colormode(m_xor);
      drawpoly();
      do {
	m_trackpen(&t);
      } while (!t.moving);
      m_colormode(m_xor);
      drawpoly();
    } while (!t.dn && t.near_);
    if (!t.dn) {
      xp[which - 1] = xx;
      yp[which - 1] = yy;
    }
  } while (true);
  exit(0);
}






/* End. */
