
/* "WOL", an integrated circuit layout tool,
   Copyright (C) 1983, 1990 California Institute of Technology.
   Author: Massimo Sivilotti
   Thanks to: Glenn Gribble, Marty Sirkin, Sylvie Rychebusch
	      Maryann Mayer, Carver Mead, Rick Koshi, Torre Lande
   Maintainer: John Lazzaro
   Maintainers's address: lazzaro@hobiecat.cs.caltech.edu;
                          CB 425/ CU Boulder/Boulder CO 91125. 
			  Send questions, bug fixes, to this address.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (Version 1, 1989).

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* Output from p2c, the Pascal-to-C translator */
/* From input file "wol_asm.text" */


#include "global.h"


#define WOL_ASM_G
#include "wol_asm.h"


void tr_2(long x1, long y1)
{
  if (tr_ctm.a == 0) {   /*a=0 & d=0, c<>0, b<>0 */
    tr_ax = y1 * tr_ctm.c + tr_ctm.e;
    tr_ay = x1 * tr_ctm.b + tr_ctm.f;
  } else {  /*a<>0, d<>0, c=0, b=0 */
    tr_ax = x1 * tr_ctm.a + tr_ctm.e;
    tr_ay = y1 * tr_ctm.d + tr_ctm.f;
  }
  /*      tr_ax := tr_ax+tr_ctm.e;
        tr_ay := tr_ay+tr_ctm.f;                       */
  if (tr_ctm.g != 1) {
    tr_ax /= tr_ctm.g;
    tr_ay /= tr_ctm.g;
  }
}


void tr_4(long x1, long y1, long x2, long y2)
{
  tr_2(x2, y2);
  tr_bx = tr_ax;
  tr_by = tr_ay;
  tr_2(x1, y1);
}


void tr_set_matrix(void)
{
}





/* End. */
