
/* "WOL", an integrated circuit layout tool,
   Copyright (C) 1983, 1990 California Institute of Technology.
   Author: Massimo Sivilotti
   Thanks to: Glenn Gribble, Marty Sirkin, Sylvie Rychebusch
	      Maryann Mayer, Carver Mead, Rick Koshi, Torre Lande
   Maintainer: John Lazzaro
   Maintainers's address: lazzaro@hobiecat.cs.caltech.edu;
                          CB 425/ CU Boulder/Boulder CO 91125. 
			  Send questions, bug fixes, to this address.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (Version 1, 1989).

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* Output from p2c, the Pascal-to-C translator */
/* p2c: wolopt.text, line 9: Note: Range checking is OFF [216] */
/* p2c: wolopt.text, line 10: Note: Stack checking is OFF [217] */
/* p2c: wolopt.text, line 16: Note: Range checking is ON [216] */
/* p2c: wol_gr_1.text, line 4: Note: Range checking is OFF [216] */
/* From input file "wol_gr_1.text" */


/* Change these for testing */




#include "global.h"


#define WOL_GRAPHICS_G
#include "wol_graphics.h"


void gsave(void)
{
  graphics_state *gnu;

  /* Get some information from MYLIB */
  gstate.linestyle = m_curlinestyle();
  gstate.colormode = m_curcolormode();
  gstate.curcolor = m_curcolor();
  if (gfree == NULL)
    gnu = Malloc(sizeof(graphics_state));
  else {
    gnu = gfree;
    gfree = gnu->next;
  }
  *gnu = gstate;
  gstate.next = gnu;
}


void grestore(void)
{
  graphics_state *gtmp;

  gtmp = gstate.next;   /* next in line */
  gstate = *gtmp;   /* restore next to power */
  /* put old stuff on free list */
  gtmp->next = gfree;
  gfree = gtmp;
  /* Now fix things in Mylib */
  m_linestyle(gstate.linestyle);
  m_colormode(gstate.colormode);
  m_color(gstate.curcolor);
  if (gstate.full_screen)
    big_graphics();
  else
    small_graphics();
}


void re_init_graphics(void)
{
  m_init_graphics_nopen();

  MAX_TOP_OF_SCREEN = m_down;   /* Top of physical screen -- 767 or 389*/
  RIGHT_OF_SCREEN = m_across;   /* Right of drawing pad. 1023 or 511*/
  X_CENTER = MAX_TOP_OF_SCREEN / 2;   /* Center of the drawing pad.  */
  Y_CENTER = TOP_OF_SCREEN / 2;

  /*$if false$
  if (m_machine = '320') or (m_machine = '700') then
   begin { super 1024x768 badgers }
        TOP_OF_SCREEN     :=  MAX_TOP_OF_SCREEN-36; { Top of graphics window (viewport)}
        END_OF_MENU       :=  900;
        MENU_SQUARE_SIZE  :=  81;                    { size of menu squares (was 90)}
        MENU_LABEL_HEIGHT :=  -12;                   { Pixels from MAX_TOP_OF_SCREEN }
      end
   else begin  { regular 512x390 chipmunks }
        TOP_OF_SCREEN     :=  MAX_TOP_OF_SCREEN-24;  { Top of graphics window (viewport)}
        END_OF_MENU       :=  450;
        MENU_SQUARE_SIZE  :=  40;                    { size of menu squares (was 45) }
        MENU_LABEL_HEIGHT :=  -7;                   { Pixels from MAX_TOP_OF_SCREEN }
    end;
$end$*/
  MENU_SQUARES = 11;
  /* next 4 lines replace $if$ above */
  TOP_OF_SCREEN = (long)(0.95 * MAX_TOP_OF_SCREEN);
  END_OF_MENU = (long)(0.9 * RIGHT_OF_SCREEN);
  MENU_SQUARE_SIZE = END_OF_MENU / MENU_SQUARES;
  MENU_LABEL_HEIGHT = -(long)(0.016 * TOP_OF_SCREEN);

  /*   END_OF_MENU       :=  MENU_SQUARE_SIZE * MENU_SQUARES; { Right of menu boxes   */
  MENU_LABEL_OFFSET = MENU_SQUARE_SIZE / 2;
      /* Pixels from left of menu box */

  m_setlinestyle(1, 0xaaaaL);
  m_setlinestyle(2, 0xccccL);
  m_setlinestyle(3, 0xf0f0L);

  big_graphics();
  m_colormode(m_over);
  m_color(WHITE);
  m_linestyle(0);
  m_choosefont(1);

  m_nocursor();
  clear_screen();
}


void init_graphics(void)
{
  long i;

  m_init_graphics_nopen();
  /*$if false$
   BOBCAT := (m_machine = '320') ; { not (currentcrt = alphatype);    }
   DUALSCREEN := (m_machine = '700');  { do we have two screens ? }
$end$*/
  gfree = NULL;
  gstate.next = NULL;
  re_init_graphics();
  /* Allocate a reasonable STACK */
  for (i = 1; i <= 15; i++)
    gsave();
  for (i = 1; i <= 15; i++)
    grestore();
  /* writeln ('Graphics initialized for machine = ',m_machine,
           '; BOBCAT = ',(m_machine = '320'),
           '; DUALSCREEN = ',(m_machine = '700'));
    for i := 1 to 500000 do ;  busy wait*/
}


/*******************************************************************************/

void big_graphics(void)
{
  /* set up clipping window to whole screen */
  m_clip(0, 0, RIGHT_OF_SCREEN, MAX_TOP_OF_SCREEN);
  gstate.full_screen = true;
}


/*******************************************************************************/

void small_graphics(void)
{
  /* set up clipping window to lambda grid */
  m_clip(0, 0, RIGHT_OF_SCREEN, TOP_OF_SCREEN);
  gstate.full_screen = false;
}


/*******************************************************************************/

void filledbox(long x1, long y1, long x2, long y2, long fill)
{
  long t, ocolor, omode;

  ocolor = m_curcolor();
  omode = m_curcolormode();

  if (fill == ocolor) {
    m_fillrect(x1, y1, x2, y2);
    return;
  }
  if (x1 > x2) {
    t = x2;
    x2 = x1;
    x1 = t;
  }
  if (y1 > y2) {
    t = y2;
    y2 = y1;
    y1 = t;
  }

  if (x2 - x1 > 1 && y2 - y1 > 1) {   /* There is something inside. */
    if (fill == 0)
      m_colormode(m_normal);
    m_color(fill);
    m_fillrect(x1 + 1, y1 + 1, x2 - 1, y2 - 1);
    if (fill == 0)
      m_colormode(omode);
    m_color(ocolor);
  }

  /* Stick on a border */
  m_drawrect(x1, y1, x2, y2);
}


/*******************************************************************************/

void clear_screen(void)
{
  /* clears the graphics screen */
  m_nocursor();
  if (!gstate.full_screen) {
    m_clearwindow(MAX_TOP_OF_SCREEN - TOP_OF_SCREEN - 2, TOP_OF_SCREEN + 3);
    return;
  }
  if (!strcmp(m_machine, "320"))
    printf("\f");
  else
    m_clear();

  /* Look out, DAVE is in TRS-80 land again!!! */
}


/*******************************************************************************/

void graphics_screen(screen_control what)
{
  /* controls the graphics screen */
  switch (what) {

  case ON:
    m_graphics_on();
    break;

  case OFF:
    m_graphics_off();
    break;

  case CLR:
    clear_screen();
    m_graphics_on();
    break;
  }
}


/*******************************************************************************/

void alpha_screen(screen_control what)
{
  /* controls the alpha screen */
  switch (what) {

  case ON:
    m_alpha_on();
    break;

  case OFF:
    m_alpha_off();
    break;

  case CLR:
    m_nocursor();
    printf("\f");
    m_alpha_on();
    break;
  }
}


/*******************************************************************************/

/* controls both the alpha and graphics screens in one call */
void both_screens(screen_control al, screen_control gr)
{
  alpha_screen(al);
  graphics_screen(gr);
}


/*******************************************************************************/

void xor_on(void)
{
  /* Turns on xor mode */
  long curcolor;

  curcolor = m_curcolor();
  m_colormode(m_xor);
  m_color(curcolor);
}


/*******************************************************************************/

void xor_off(void)
{
  /* Turns off xor mode */
  long curcolor;

  curcolor = m_curcolor();
  m_colormode(m_over);
  m_color(curcolor);
}


/*******************************************************************************/

void display_text(Char *text_line)
{
  /* Displays text at current graphics position */
  m_moverel(0, 7);   /*  Adjust for TRS-80 Land  */
  m_displaytext(text_line);
}


/*******************************************************************************/

/* MODULE wol_graphics */



/* End. */
