/* Header for module wol_graphics, generated by p2c */
#ifndef WOL_GRAPHICS_H
#define WOL_GRAPHICS_H


#ifndef SYSGLOBALS_H
#include <p2c/sysglobals.h>
#endif

#ifndef SYSDEVS_H
#include <p2c/sysdevs.h>
#endif

#ifndef MYLIB_H
#include <p2c/mylib.h>
#endif


#ifdef WOL_GRAPHICS_G
# define vextern
#else
# define vextern extern
#endif


#define BLACK           0   /* various colors */
#define RED             1
#define GREEN           2
#define YELLOW          3
#define BLUE            4
#define PURPLE          5
#define CYAN            6
#define BR_WHITE        7
#define OLIVE_GREEN     8
#define AQUA            9
#define ROYAL_BLUE      10
#define MAROON          11
#define BRICK_RED       12
#define ORANGE          13
#define BROWN           14
#define WHITE           15


typedef enum {
  ON, OFF, CLR, NOTHING
} screen_control;

typedef struct graphics_state {
  struct graphics_state *next;
  boolean full_screen;
  long linestyle, colormode, curcolor;
  boolean ref_in_black, dotted;
} graphics_state;


vextern graphics_state gstate, *gfree;

vextern double zoom;   /* zoom factor           */
vextern short izoom;   /* trunc(zoom)           */
vextern boolean intzoom;   /* = (zoom=izoom)        */

/*$if false$
   BOBCAT : boolean;   { set to true if BOBCAT screen being used }
   DUALSCREEN : boolean;  { do we have two screens ? }
$end$*/

vextern long MENU_SQUARES;   /* Number of menu squares */
vextern long MENU_SQUARE_SIZE;   /* Number of pixels width for menu squares */
vextern long MAX_TOP_OF_SCREEN;   /* Top of physical screen */
vextern long RIGHT_OF_SCREEN;   /* Right of drawing pad.       */
vextern long TOP_OF_SCREEN;   /* Top of graphics window (viewport)*/
vextern long END_OF_MENU;   /* Right of menu boxes   */
vextern long X_CENTER, Y_CENTER;   /* Center of the drawing pad.  */
vextern long MENU_LABEL_OFFSET;   /* Pixels from left of menu box */
/* Pixels from MAX_TOP_OF_SCREEN */
vextern long MENU_LABEL_HEIGHT;


extern void gsave(void);
extern void grestore(void);

extern void re_init_graphics(void);
extern void init_graphics(void);
extern void big_graphics(void);
extern void small_graphics(void);
extern void filledbox(long x1, long y1, long x2, long y2, long fill);
/*PROCEDURE color(clr : integer);*/
extern void clear_screen(void);
extern void graphics_screen(screen_control what);
extern void alpha_screen(screen_control what);
extern void both_screens(screen_control al, screen_control gr);
extern void xor_on(void);
extern void xor_off(void);
extern void display_text(Char *text_line);


#undef vextern

#endif /*WOL_GRAPHICS_H*/

/* End. */
