/* Header for module wol_graphics_2, generated by p2c */
#ifndef WOL_GRAPHICS_2_H
#define WOL_GRAPHICS_2_H


#ifndef ASM_H
#include <p2c/asm.h>
#endif

#ifndef SYSGLOBALS_H
#include <p2c/sysglobals.h>
#endif

/*file support*/

#ifndef FS_H
#include <p2c/fs.h>
#endif

#ifndef MISC_H
#include <p2c/misc.h>
#endif

#ifndef SYSDEVS_H
#include <p2c/sysdevs.h>
#endif

/* by      Tim Mikkelsen
   date    07/17/81
   update  03/09/83

   purpose This module contains the LEVEL
           2 HPIB GROUP procedures.

 */


#ifndef HPIB_2_H
#include <p2c/hpib_2.h>
#endif

#ifndef HPIB_1_H
#include <p2c/hpib_1.h>
#endif

#ifndef GENERAL_1_H
#include <p2c/general_1.h>
#endif

#ifndef GENERAL_2_H
#include <p2c/general_2.h>
#endif

#ifndef FILEPACK_H
#include <p2c/filepack.h>
#endif

#ifndef NEWKBD_H
#include <p2c/newkbd.h>
#endif

#ifndef MYLIB_H
#include <p2c/mylib.h>
#endif

#ifndef NEWCI_H
#include <p2c/newci.h>
#endif

#ifndef WOL_GRAPHICS_H
#include "wol_graphics.h"
#endif

#ifndef WOL_ASM_H
#include "wol_asm.h"
#endif

#ifndef HPGL_PLOTTER_H
#include "hpgl_plotter.h"
#endif

#ifndef TIMING_H
#include "timing.h"
#endif

/* General stuff for dealing with layers.  This is placed in a module to put */
/* everything in one place.  Some conventions for dealing with layers, etc.: */
/*    Every routine is responsible for setting the current layer/color/... to*/
/*       its desired value.  This requires some slight caution when calling  */
/*       other routines, but means that box drawing routines do not need to  */
/*       save and restore the color each time for each call.                 */

#ifndef LAYER_STUFF_H
#include "layer_stuff.h"
#endif

#ifndef TABLET_STUFF_H
#include "tablet_stuff.h"
#endif

#ifndef MESSAGE_STUFF_H
#include "message_stuff.h"
#endif

/* define the major cell stuff in use */

#ifndef CELL_STUFF_H
#include "cell_stuff.h"
#endif

#ifndef NAME_STUFF_H
#include "name_stuff.h"
#endif

#ifndef WOL_HEADER_H
#include "wol_header.h"
#endif


#ifdef WOL_GRAPHICS_2_G
# define vextern
#else
# define vextern extern
#endif


#define min_mem_recurse  1000
    /* minimum amount of memory during recursion */


extern void do_refresh(void);
extern void set_buffer(Char *n);
extern void make_buffer(Char *n, _PROCEDURE p);

extern void draw_routing(routing *rt);
extern void make_matrix(void);
extern tablet_info scale(tablet_info in_val, short arg);
extern point scale_up(point tlp);
extern point scale_down(point tlp);
extern point change_to_point(long a, long b);
extern tablet_info tr_pen(void);
extern tablet_info track(void);
extern point transform_point(point pt);
/* XFORM */
extern bb_states bb_check(point bll, point bur);
extern void smartbox(long x1, long y1, long x2, long y2);
extern void draw_rbb(point pta, point ptb);
extern boolean within(node *t, point d1, point d2, short fl);
extern node *parent_of(node *st, point c1, point c2, short flg);
extern void add_wire(point p1, point p2, short l, Char *name, port_node *port);
extern boolean get_rbb(point *start, point *finish);
extern void make_wire(point start, short l);
extern void draw_wire_box(long ax, long ay, long bx, long by);
extern void draw_wire(point a, point b);
extern void redisplay(node *t_p);
extern void refresh_geom(void);
extern void small_clear(void);
extern void show_comp_2(c_cell *root);
extern void show_comp(void);
extern void fast_add(point p1, point p2, short l, Char *name, port_node *port);
extern void reshuffle(node *shuf_obj);
extern void fast_shuf(node *shuf_obj);
extern void reinstate(void);
/* Puts the last moved nodes back into the tree */
extern void inc_nodes(node *n, long dx, long dy);
extern void node_out_of_tree(node *obj);
extern void restore_in_tree(node *n);
extern void move_a_tree(node *obj, point start);
extern void set_c_bb(comp_list *c);
extern void set_bb(cell *c);
extern void xform_node(c_cell *c, point *vll, point *vur);
extern void scroll_window(boolean immediate, Char firstchar);
extern void zoom_it(double new_zoom);
extern void window_zoom(boolean switch_windows);
extern void highlight_g(node *nd);
extern void unhighlight_g(node *nd);
extern void highlight_c(c_cell *nd);
extern void unhighlight_c(c_cell *nd);
extern void select_object(point pt);
extern void find_all_possible_objects(point pt);
extern void push_window(void);
extern void pop_window(void);
extern void exchange_window(void);
extern void draw_arrow(point start, point finish, boolean erase);
extern void do_ruler(point start);


#undef vextern

#endif /*WOL_GRAPHICS_2_H*/

/* End. */
