/* Header for module wol_header, generated by p2c */
#ifndef WOL_HEADER_H
#define WOL_HEADER_H


#ifndef SYSGLOBALS_H
#include <p2c/sysglobals.h>
#endif

#ifndef WOL_GRAPHICS_H
#include "wol_graphics.h"
#endif

#ifndef TIMING_H
#include "timing.h"
#endif

/* General stuff for dealing with layers.  This is placed in a module to put */
/* everything in one place.  Some conventions for dealing with layers, etc.: */
/*    Every routine is responsible for setting the current layer/color/... to*/
/*       its desired value.  This requires some slight caution when calling  */
/*       other routines, but means that box drawing routines do not need to  */
/*       save and restore the color each time for each call.                 */

/*homeless orphans*/

#ifndef LAYER_STUFF_H
#include "layer_stuff.h"
#endif

/* Lots of the tablet stuff. */

#ifndef TABLET_STUFF_H
#include "tablet_stuff.h"
#endif

#ifndef MESSAGE_STUFF_H
#include "message_stuff.h"
#endif

/* define the major cell stuff in use */

#ifndef CELL_STUFF_H
#include "cell_stuff.h"
#endif

#ifndef NAME_STUFF_H
#include "name_stuff.h"
#endif


#ifdef WOL_HEADER_G
# define vextern
#else
# define vextern extern
#endif


/* CAGED_date="r   Compilation_date ='$X';" */

#define Compilation_date  "Mar 29, 1989 8:25 pm"
#define Version         "1.11"


#define COM68020        false
/* set if compiled for 68020,
                        used in $if compiler directives */


#define POLY            1   /* POLY      =  red      */
#define DIFF            2   /* DIFFUSION = green     */
#define METAL           4   /* METAL     = blue      */
#define IMP             3   /* IMPLANT   = yellow    */
#define BUR             14   /* BURIED    = brown     */
#define CUT             7   /* CUT       = white     */
#define BOUND           5   /* Bounding box = purple */
#define GLASS           6   /* Overglass = cyan      */
#define POLYPAD         11   /* Magic Poly pad mode   */

#define INFIN           32767   /* Far, far away...            */


/*******************************************************************************/

/* A bounding box can either be ON the screen, CLIPPED by the screen, or */
/* completely OFF the screen. */
typedef enum {
  bb_on, bb_clip, bb_off
} bb_states;

/*******************************************************************************/


typedef char xfrow[8];
typedef xfrow xformarray[8];


vextern const xformarray xf;


typedef struct deferred_rec {
  struct deferred_rec *next;
  point ll, ur;
  long layer;
} deferred_rec;

typedef struct window_rec {
  struct window_rec *next;
  long off_x, off_y;
  double zoom;
  short izoom;
  boolean intzoom;
} window_rec;

/* Information for display buffers */


#define max_buffer      3


typedef struct buffer_rec {
  short b_izoom;
  boolean b_intzoom;
  double b_zoom;
  long b_off_x, b_off_y;
  _PROCEDURE refresh;
  Char name[6];
  window_rec *windows;
} buffer_rec;

typedef buffer_rec buffer_array[max_buffer + 1];

/*******************************************************************************/


vextern long STARTVARS;
vextern boolean debug_clip;   /* clip boxes??? */

/* Make these new kinds for the CORE allocator */
/*geom_window_stack   : window_ptr;   { stack of window transformations     */
/*comp_window_stack   : window_ptr;   { stack of window transformations     */
vextern window_rec *garbage_window_stack;
    /* free list for window stack elements */

vextern deferred_rec *deferred_stack;   /* list of all deferreds in a cell */
vextern deferred_rec *last_deferred;
    /* last deferred used on the deferred_stack */

vextern short current_buffer;   /* either GEOM, COMP, or XTR */
vextern Char current_buffer_name[6];
vextern buffer_array display_buffers;   /* Array of all of them. */

vextern short sel_box;   /* "Layer" of select box          */
vextern short comp_box;   /* "Layer" of composition boxes   */
vextern short bb;   /* Layer of bounding box          */

vextern long wire_width;   /* width of routing wires */
vextern boolean manhattan_routing;   /* permit only manhattan routing */
vextern boolean fleshed_out_routing;
    /* display full routing wires, not centrelines */

vextern tablet_info pen_data;   /* Current pen info      */
vextern long off_x, off_y;   /* screen offsets        */
vextern bb_states bb_state;   /* Used by refresh routines */

vextern Char technology[fidleng + 1];   /* Current technology */
vextern Char technology2[fidleng + 1], technology3[fidleng + 1];
    /* Standard technologies */
vextern short lambda_to_microns;   /* lambda in 1/100 microns */
vextern boolean cursor_on;   /* Draw the cursor?      */

vextern node *main_;   /* Current work tree of nodes.       */
vextern node *del_nodes[5];   /* Deleted nodes list */
vextern node *last_added;   /* Last added pointer (for move bb) */

vextern boolean auto_refresh;   /* decide when to refresh by itself */
vextern boolean ref_flg;   /* Refresh menu?            */
vextern boolean making_wire;   /* Are we making a wire?    */
vextern boolean first_dotted;   /* Move first shape is dotted?       */
vextern boolean retain_nodes;   /* Should we garb coll nodes (on reshuffle) */
vextern boolean bbox_nobbox;   /* Display bounding boxes?? */

vextern node *last_moved;   /* The last object moved    */

vextern Char curr_geom_cell[81];   /* last cell loaded into buffer */
vextern Char curr_comp_cell[81];   /* last cell loaded into buffer */

vextern short a_w_layer;   /* Storage for read/write cif layers */
vextern a_w_node *a_w_list;   /* List of already written cells     */
vextern short a_w_count;   /* Symbol numbers for writing cif    */
vextern short initial_cif_symbol_number;   /*starting symbol number for cif */
vextern FILE *cif_fil;   /* Cif file parameter                */

vextern boolean defining_cell;   /* Now defining a cell?              */
vextern boolean cif_prefix_found;   /* Did the parser find cif 84 or 85? */
vextern Char cif_prefix_name[11];   /* The prefix it found, if any       */
vextern short cell_scale;   /* Cell box scale factor             */
vextern Char d_cell_name[81];   /* Cell defined name.                */
vextern point d_cell_ll;   /* BB for defined cell.              */
vextern point d_cell_ur;   /* "                  "              */
vextern short d_cif_layer;   /* Defined wire's layer.             */
vextern boolean d_set_bb;   /* Has BB been set?                  */
vextern comp_list *d_c_p;   /* Current comp cell, during read.   */
vextern cell_typ cif_cell;   /* Current cell type                 */

vextern short xform;   /* Current xform in comp buffer      */
vextern short geometry_xform;   /* Current xform in geom buffer      */

/* random lists for augmented selection algorithms */
vextern boolean ok_to_select;   /* TRUE if it is OK to do selection now*/
vextern node *last_selected_object_g;
    /* NIL if no object selected previously */
vextern boolean select_in_progress_g;
    /* TRUE if <EXECUTE> pressed before pen-lift */
vextern point select_pen_position_g;   /* point being selected */
vextern node *select_list_head_g, *select_list_tail_g;
vextern c_cell *last_selected_object_c;
    /* NIL if no object selected previously */
vextern boolean select_in_progress_c;
    /* TRUE if <EXECUTE> pressed before pen-lift */
vextern point select_pen_position_c;   /* point being selected */
vextern c_cell *select_list_head_c, *select_list_tail_c;
vextern boolean edges_only;   /* selection sensitive to edges only */

vextern long background_color;
vextern boolean display_ports;   /* true if ports should be displayed */
vextern boolean disable_heirarchy, point_to_point_move;
    /* if true, do not redraw DURING move */
vextern boolean cells_modified;   /* set by show_modified if cells changed */
vextern boolean quiet_startup;   /* do not read motd, and minimize CIF dots */

vextern Char wol_username[11];   /* name of user */
vextern Char WolLib[81];   /* name of library (diff. for UNIX) */



/*******************************************************************************/

vextern long ENDVARS;   /* *KLUGE* to erase all variables */


/*******************************************************************************/


#undef vextern

#endif /*WOL_HEADER_H*/

/* End. */
