/* Header for module wol_menu, generated by p2c */
#ifndef WOL_MENU_H
#define WOL_MENU_H


#ifndef ASM_H
#include <p2c/asm.h>
#endif

#ifndef SYSGLOBALS_H
#include <p2c/sysglobals.h>
#endif

/*file support*/

#ifndef FS_H
#include <p2c/fs.h>
#endif

#ifndef MISC_H
#include <p2c/misc.h>
#endif

#ifndef SYSDEVS_H
#include <p2c/sysdevs.h>
#endif

/* by      Tim Mikkelsen
   date    07/17/81
   update  03/09/83

   purpose This module contains the LEVEL
           2 HPIB GROUP procedures.

 */


#ifndef HPIB_2_H
#include <p2c/hpib_2.h>
#endif

#ifndef HPIB_1_H
#include <p2c/hpib_1.h>
#endif

#ifndef GENERAL_1_H
#include <p2c/general_1.h>
#endif

#ifndef GENERAL_2_H
#include <p2c/general_2.h>
#endif

#ifndef FILEPACK_H
#include <p2c/filepack.h>
#endif

#ifndef NEWKBD_H
#include <p2c/newkbd.h>
#endif

#ifndef CITINFOMOD_H
#include <p2c/citinfomod.h>
#endif

#ifndef NEWCI_H
#include <p2c/newci.h>
#endif

#ifndef MYLIB_H
#include <p2c/mylib.h>
#endif

#ifndef NEWASM_H
#include <p2c/newasm.h>
#endif

#ifndef WOL_GRAPHICS_H
#include "wol_graphics.h"
#endif

#ifndef WOL_ASM_H
#include "wol_asm.h"
#endif

#ifndef TIMING_H
#include "timing.h"
#endif

#ifndef LAYER_STUFF_H
#include "layer_stuff.h"
#endif

#ifndef TABLET_STUFF_H
#include "tablet_stuff.h"
#endif

#ifndef MESSAGE_STUFF_H
#include "message_stuff.h"
#endif

/* define the major cell stuff in use */

#ifndef CELL_STUFF_H
#include "cell_stuff.h"
#endif

#ifndef NAME_STUFF_H
#include "name_stuff.h"
#endif

#ifndef HPGL_PLOTTER_H
#include "hpgl_plotter.h"
#endif

#ifndef WOL_HEADER_H
#include "wol_header.h"
#endif

#ifndef WOL_GRAPHICS_2_H
#include "wol_graphics_2.h"
#endif


#ifdef WOL_MENU_G
# define vextern
#else
# define vextern extern
#endif


#define border_color    6
#define select_color    5


/* Tablet procedure */

/* Tablet procedure, with sub-modes */

typedef union menu_ptr {
  long int_;
  void *any;
  struct menu_rec *recp;
  struct menu_head *headp;
  boolean *boolp;
  long *intp;
  Char *strp;
  short *shortp;
} menu_ptr;

typedef enum {
  mn_null, mn_radio, mn_radio2, mn_bool, mn_action, mn_change, mn_layer
} menu_kinds;
typedef Char menu_modes[64][8];

typedef struct menu_submoderec {
  _PROCEDURE t2proc;
  short mode, nummodes;
  Char (*modes)[8];
} menu_submoderec;

typedef struct menu_rec {
  struct menu_rec *next;   /* next menu item in the list */
  struct menu_head *head;   /* Which menu do I belong to? */
  Char name[8];   /* Displayed name of this item */
  Char lookup[8];   /* Lookup name of this item */
  short color;   /* Menu name color */
  boolean selected;   /* Currently selected? */
  short pos;   /* Position */
  _PROCEDURE proc;   /* This gets called when selected */

  menu_kinds tag;
  union {
    struct {
      long null1, null2;
    } U0;
    _PROCEDURE tproc;
    menu_submoderec *more;
    boolean *boolp;
    _PROCEDURE aproc;
    Char *strp;
    long layer;
  } UU;
} menu_rec;

typedef struct menu_head {
  struct menu_head *next;   /* Pointer to next full menu */
  menu_rec *menu;   /* Pointer to menu items */
  Char name[8];   /* Name of whole menu */
  _PROCEDURE tproc;   /* Normal tablet procedure */
  _PROCEDURE t2proc;   /* Sub-mode tablet procedure */
  _PROCEDURE init;   /* Called each time the menu is entered. */
  _PROCEDURE exit;   /* Called each time the menu is exited. */
  Char modestr[8];   /* ALL, ONE, SEL, ... */
  short modenum;   /* Numeric value of modestr (-1 if no mode) */
  short squares;   /* Number of squares in menu */
} menu_head;


vextern menu_head *all_menus, *menu_curr, *menu_prev;
vextern boolean menu_erase;   /* Erase menu next time it is drawn? */

vextern short menu_pos;   /* Which menu item? */

vextern Char comp_menu[8];   /* Which comp-menu was I last in? */

vextern boolean quit;

vextern boolean showing_geometry;


extern menu_rec *menu_add(Char *name, menu_kinds tag, short color,
			  _PROCEDURE proc);
extern boolean menu_check(long x, long y);
extern menu_head *menu_find(Char *name);
extern menu_rec *menu_find_item(menu_head *menu, Char *name);

extern void new_menu(Char *name, _PROCEDURE tproc, _PROCEDURE init,
		     _PROCEDURE exit);
extern void menu_show(void);
extern void menu_press(menu_rec *item);
extern void menu_change(Char *newmenu);
extern void add_radio(Char *name, short color, _PROCEDURE tproc);
/* Tablet/submode proc */
/* How many alternate modes */
extern void add_radio2(Char *name, short color, _PROCEDURE t2proc,
		       short nummodes, Char (*modes)[8]);
/* Array of names */
extern void add_bool(Char *name, short color, boolean *boolvar);
extern void add_drc(Char *name, short color);
extern void add_display(Char *name, short color);
extern void add_mlayer(Char *name, short color, short layer);
extern void add_action(Char *name, short color, _PROCEDURE proc);
extern void add_menuchange(Char *name, Char *newmenu);
extern void add_menuchangeVar(Char *name, Char *newmenu);

/*procedure p_display(mp:menu_recp);
{procedure p_menu(mp:menu_recp);
{procedure p_layer(mp:menu_recp);
{procedure p_action(mp:menu_recp);
{procedure p_radio(mp:menu_recp);
{procedure p_radio2(mp:menu_recp);
{procedure p_bool(mp:menu_recp);*/


#undef vextern

#endif /*WOL_MENU_H*/

/* End. */
