/* Header for module wol_options, generated by p2c */
#ifndef WOL_OPTIONS_H
#define WOL_OPTIONS_H


#ifndef SYSGLOBALS_H
#include <p2c/sysglobals.h>
#endif

#ifndef SYSDEVS_H
#include <p2c/sysdevs.h>
#endif

#ifndef GENERAL_2_H
#include <p2c/general_2.h>
#endif

#ifndef NEWKBD_H
#include <p2c/newkbd.h>
#endif

#ifndef WOL_GRAPHICS_H
#include "wol_graphics.h"
#endif

#ifndef TIMING_H
#include "timing.h"
#endif

/* General stuff for dealing with layers.  This is placed in a module to put */
/* everything in one place.  Some conventions for dealing with layers, etc.: */
/*    Every routine is responsible for setting the current layer/color/... to*/
/*       its desired value.  This requires some slight caution when calling  */
/*       other routines, but means that box drawing routines do not need to  */
/*       save and restore the color each time for each call.                 */

#ifndef LAYER_STUFF_H
#include "layer_stuff.h"
#endif

/* Lots of the tablet stuff. */

#ifndef TABLET_STUFF_H
#include "tablet_stuff.h"
#endif

#ifndef MESSAGE_STUFF_H
#include "message_stuff.h"
#endif

/* define the major cell stuff in use */

#ifndef CELL_STUFF_H
#include "cell_stuff.h"
#endif

#ifndef NAME_STUFF_H
#include "name_stuff.h"
#endif

#ifndef WOL_HEADER_H
#include "wol_header.h"
#endif


#ifdef WOL_OPTIONS_G
# define vextern
#else
# define vextern extern
#endif


typedef Char enumStrA[256][15];
typedef enum {
  d_str, d_short, d_enum, d_int
} dispKinds;   /* more to come */
typedef enum {
  sp_none, sp_tab, sp_tech, sp_lambda, sp_redraw, sp_back_color
} dispSpecials;

typedef struct dispRec {
  struct dispRec *next;
  short line;   /* which relative line on screen? */
  Char name[41];
  unsigned special : 3;
/* p2c: wol_options.text, line 52: Note:
 * Field width for SPECIAL assumes enum dispSpecials has 6 elements [105] */
/* p2c: wol_options.text, line 53:
 * Note: Field width for KIND assumes enum dispKinds has 4 elements [105] */
  unsigned kind : 2;
  union {
    struct {
      Char *strcur, *strleft, *strright;
      short strmax;
    } U0;
    struct {
      short *shcur, shmax, shmin;
    } U1;
    struct {
      long *intcur, intmax, intmin;
    } U3;
    struct {
      Char *ecur;
      uchar emax, emin;
      Char (*enames)[15];
    } U2;
  } UU;
} dispRec;


vextern short old_mode;
vextern dispRec *dispHead;
vextern short dispLine;   /* current line */
vextern short numOpt;


extern void dispStr(Char *name, Char *c, Char *l, Char *r);
extern void dispShort(Char *name, short *s, short max, short min);
extern void dispInt(Char *name, long *s, long max, long min);
extern void dispEnum(Char *name, Char *e, short max, short min, Char (*p)[15]);
extern void dispLEnum(Char *name, Char *e, short max, short min,
		      Char (*p)[15]);
extern void cmd_options(void);
/* PROCEDURE setupDisp;  */


#undef vextern

#endif /*WOL_OPTIONS_H*/

/* End. */
