
/* "WOL", an integrated circuit layout tool,
   Copyright (C) 1983, 1990 California Institute of Technology.
   Author: Massimo Sivilotti
   Thanks to: Glenn Gribble, Marty Sirkin, Sylvie Rychebusch
	      Maryann Mayer, Carver Mead, Rick Koshi, Torre Lande
   Maintainer: John Lazzaro
   Maintainers's address: lazzaro@hobiecat.cs.caltech.edu;
                          CB 425/ CU Boulder/Boulder CO 91125. 
			  Send questions, bug fixes, to this address.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (Version 1, 1989).

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* Output from p2c, the Pascal-to-C translator */
/* p2c: wolopt.text, line 9: Note: Range checking is OFF [216] */
/* p2c: wolopt.text, line 10: Note: Stack checking is OFF [217] */
/* p2c: wolopt.text, line 16: Note: Range checking is ON [216] */
/* From input file "wolaudit.text" */


/* Change these for testing */



#include "global.h"


#define WOL_AUDIT_G
#include "wol_audit.h"


Static audit_rec *proc_list, *current_proc;
Static long global_depth;


void audit_proc(Char *s)
{
  audit_rec *tmp_proc, *tmp2_proc;

  tmp_proc = Malloc(sizeof(audit_rec));
  global_depth++;
  tmp_proc->parent = current_proc;
  tmp_proc->next = NULL;
  tmp_proc->calls = NULL;
  strcpy(tmp_proc->str, s);
  tmp_proc->depth = global_depth;
  if (current_proc->calls == NULL)
    current_proc->calls = tmp_proc;
  else {
    tmp2_proc = current_proc->calls;
    while (tmp2_proc->next != NULL)
      tmp2_proc = tmp2_proc->next;
    tmp2_proc->next = tmp_proc;
  }
  current_proc = tmp_proc;
}


void audit_exit_proc(void)
{
  current_proc = current_proc->parent;
  global_depth--;
}


void audit_message(Char *s)
{
  audit_rec *tmp_proc, *tmp2_proc;

  tmp_proc = Malloc(sizeof(audit_rec));
  tmp_proc->parent = current_proc;
  tmp_proc->next = NULL;
  tmp_proc->calls = NULL;
  strcpy(tmp_proc->str, s);
  tmp_proc->depth = -1;   /* magic message flag */
  if (current_proc->calls == NULL)
    current_proc->calls = tmp_proc;
  else {
    tmp2_proc = current_proc->calls;
    while (tmp2_proc->next != NULL)
      tmp2_proc = tmp2_proc->next;
    tmp2_proc->next = tmp_proc;
  }
  current_proc = tmp_proc;
}


void audit_init(void)
{
  audit_rec *WITH;

  proc_list = Malloc(sizeof(audit_rec));
  global_depth = 0;
  current_proc = proc_list;
  WITH = proc_list;
  WITH->parent = NULL;
  WITH->next = NULL;
  WITH->calls = NULL;
  strcpy(WITH->str, "MAIN");
  WITH->depth = global_depth;
}


/* Local variables for audit_dump: */
struct LOC_audit_dump {
  long max_depth, i;
} ;

Local void print_it(FILE **out, audit_rec *proc, long offset,
		    struct LOC_audit_dump *LINK)
{
  audit_rec *tmp, *tmp2;

  printf("%*c%s", (int)offset, ' ', proc->str);
  if (proc->depth != -1)
    printf("; depth = %ld", proc->depth);
  putchar('\n');
  tmp = proc->calls;
  while (tmp != NULL) {
    if (proc->depth < LINK->max_depth)
      print_it(out, tmp, offset + 3, LINK);
    else {
      printf("%*c....  recursion depth print limit reached.",
	     (int)offset, ' ');
      tmp2 = tmp;
      while (tmp2->calls != NULL)
	tmp2 = tmp2->calls;
      LINK->i = tmp2->depth;
      printf("  Maximum depth = %ld\n", LINK->i);
    }
    tmp = tmp->next;
  }
}


void audit_dump(Char *fid, long max_depth_)
{
  struct LOC_audit_dump V;
  FILE *outfyle;

  V.max_depth = max_depth_;
  outfyle = NULL;
  if (outfyle != NULL)
    outfyle = freopen(fid, "w", outfyle);
  else
    outfyle = fopen(fid, "w");
  if (outfyle == NULL)
    _EscIO(FileNotFound);
  print_it(&outfyle, proc_list, 1, &V);
  if (outfyle != NULL)
    fclose(outfyle);
  outfyle = NULL;
  if (outfyle != NULL)
    fclose(outfyle);
}





/* End. */
