
/* "WOL", an integrated circuit layout tool,
   Copyright (C) 1983, 1990 California Institute of Technology.
   Author: Massimo Sivilotti
   Thanks to: Glenn Gribble, Marty Sirkin, Sylvie Rychebusch
	      Maryann Mayer, Carver Mead, Rick Koshi, Torre Lande
   Maintainer: John Lazzaro
   Maintainers's address: lazzaro@hobiecat.cs.caltech.edu;
                          CB 425/ CU Boulder/Boulder CO 91125. 
			  Send questions, bug fixes, to this address.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (Version 1, 1989).

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* Output from p2c, the Pascal-to-C translator */
/* From input file "wolcells.text" */


#include "global.h"



#define semi            ';'


/* CAGED_DATE="r       Compilation_Date = '$X'; " */

#define Compilation_Date  "Oct 1, 1985 4:27 pm"



Static boolean save_line;   /* save line if EOL found */
Static Char revdate[121], curr_cellname[121];

Static Char fbuf[121];
Static FILE *infile;
Static Char infilename[81], outfilename[81], basename[81];
Static boolean dbug;
Static long revnum, line_number;
Static Char ch, corners_owned;
Static Char pbuf[256];


Static long import;


#define namefield       18


/* p2c: wolcells.text, line 37:
 * Warning: Expected a colon, found 'newci' [227] */


Static void parse_def(void)
{
  long i, k, len;

  switch (fbuf[1]) {

  case 'S':
    strcpy(curr_cellname, "**UNKNOWN**");
    revnum = 0;
    strcpy(revdate, "**UNKNOWN**");
    break;

  case 'F':
    if (strcmp(revdate, "**UNKNOWN**")) {
      k = namefield - strlen(curr_cellname);
      while (k < 0)
	k += 4;
      pbuf[0] = '\0';
      for (i = 0; i < k; i++) {
	sprintf(pbuf + i, " ");
	len = strlen(pbuf) + 1;
      }
      sprintf(pbuf + k - 1, "%s:    %3ld    %s",
	      curr_cellname, revnum, revdate);
      len = strlen(pbuf) + 1;
      puts(pbuf);
    }
    break;

  default:
    printf("PARSE_DEF cannot handle: %s\n", fbuf);
    break;
  }
}

#undef namefield


Static void parse_comment(void)
{
  long len;
  Char *STR1;
  Char *TEMP;

  switch (fbuf[1]) {

  case 'N':
    revnum = strtol(fbuf + 21, &STR1, 10);
    len = STR1 - fbuf + 1;
    break;

  case 'D':
    sprintf(revdate, "%.*s", (int)(strlen(fbuf) - 26), fbuf + 20);
    break;

  default:
    while (strpos2(fbuf, ")", 1) == 0) {
      fgets(fbuf, 121, infile);
      TEMP = strchr(fbuf, '\n');
      if (TEMP != NULL)
	*TEMP = 0;
      line_number++;
    }
    break;
  }
}


Static void parse_cellname(Char *cellname)
{
  sprintf(cellname, "%.*s", (int)(strlen(fbuf) - 3), fbuf + 2);
}


Static void parse_end(void)
{
}


main(int argc, Char *argv[])
{
  Char STR1[256];

  PASCAL_MAIN(argc, argv);
/* p2c: wolcells.text, line 94: Warning: Expected END, found a '^' [227] */



  infile = NULL;
  if (P_argc == 2) {
    strcpy(infilename, &ARGV);
/* p2c: wolcells.text, line 94:
 * Warning: Symbol 'ARGV' is not of the appropriate class [222] */
/* p2c: wolcells.text, line 94:
 * Warning: Mixing non-strings with strings [170] */
  }
  if (infile != NULL)
    fclose(infile);
  exit(0);
}



/* End. */
