/* Header for module Globals, generated by p2c */
#ifndef GLOBALS_H
#define GLOBALS_H


#ifndef LOGDEF_H
#include "logdef.h"
#endif

#ifndef NEWCI_H
#include <p2c/newci.h>
#endif

#ifndef MYLIB_H
#include <p2c/mylib.h>
#endif

#ifndef NEWASM_H
#include <p2c/newasm.h>
#endif


#ifdef GLOBALS_G
# define vextern
#else
# define vextern extern
#endif


/*T*/



#define AnaUsingAlarm   false

/*Floating point hardware flag*/

#define AnaFloat        false
#define AnaDebugflag    false

/*Initialize floating point*/


/*$If Float$
$float_hdw on$
$End$*/

/*$If Debugflag$
$Debug$
$End$*/

/*Things nobody would ever change*/


#define AnaLarge        1000000L
    /*Dummy size of dynamically allocatable arrays*/
#define AnaNotyet       (-1000000L)


/*Limits on simulation variables*/

#define AnaParamnum     16

#define AnaN_Vdd        1
#define AnaVddmax       20
#define AnaVddmin       0.1

#define AnaN_Vstep      2
#define AnaVstepmax     AnaVddmax
#define AnaVstepmin     0

#define AnaN_Highest    3
#define AnaHighestmax   50

#define AnaN_Lowest     4
#define AnaLowestmin    (-50)

#define AnaN_Dtmax      5

#define AnaDtmaxmax     1e20
#define AnaDtmaxmin     1e-300

#define AnaN_Timerelax  6

#define AnaTimerelaxmax  1e20
#define AnaTimerelaxmin  1e-300

#define AnaN_Timemin    7

#define AnaTimeminmin   1e-300
#define AnaTimeminmax   1e-10

#define AnaN_Tol        8
#define AnaTolmax       10

#define AnaTolmin       1e-30

#define AnaN_Eqn_Epsilon  9

#define AnaEqn_epsilonmax  1e-8
#define AnaEqn_epsilonmin  1e-300

#define AnaN_Vardone_Epsilon  10

#define AnaVardone_epsilonmax  1e-8
#define AnaVardone_epsilonmin  1e-300

#define AnaN_Timefactor  11
#define AnaTimefactormax  1000
#define AnaTimefactormin  2

#define AnaN_Timeincrease  12
#define AnaTimeincreasemax  10
#define AnaTimeincreasemin  1

#define AnaN_Iterfirstmax  13

#define AnaIterfirstmaxmax  100000L

#define AnaIterfirstmaxmin  2

#define AnaN_Srange     14

#define AnaSrangemax    1e8

#define AnaSrangemin    1

#define AnaN_Small      15

#define AnaSmallmax     0.5
#define AnaSmallmin     (-0.5)

#define AnaN_Nodecap    16

#define AnaNodecapmin   1e-100
#define AnaNodecapmax   1e-10


/*constants for equation solver*/

#define AnaRowbound     62
#define AnaColbound     63

/*constants for history mode attributes*/

#define AnaH_Color      1
#define AnaH_PhosVis    2
#define AnaH_Sigdig     3
#define AnaH_Method     4
#define AnaH_Scale      5
#define AnaH_LinOffset  6
#define AnaH_Vzero      7
#define AnaH_LogOffset  8
#define AnaH_Present    9

/*constants for log plotting*/

#define AnaLn10         2.302585093
#define AnaInvLn10      0.4342944819

#define AnaLinear       0
#define AnaLog          1

/*final stops for quantities*/

#define AnaCapTooSmall  1e-60
#define AnaCapTooBig    1e3
#define AnaResTooSmall  1e-15
#define AnaResTooBig    1e15
#define AnaITooBig      1e15
#define AnaITooSmall    1e-60
#define AnaVTooBig      1e3
#define AnaVTooSmall    1e-60
#define AnaPhaseTooBig  1e3
#define AnaFreqTooBig   1e10
#define AnaTimeTooBig   1e60
#define AnaTimeTooSmall  1e-60

/*Constants for probe mode*/

#define AnaMessFlags    0
#define AnaMessScoreboard  1
#define AnaMessNode     2
#define AnaMessGate1    3
#define AnaMessGate2    4
#define AnaMessGate3    5
#define AnaMessGate4    6
#define AnaMessGate5    7


/*============================================================================*/
/* This first block represents simulation and extraction information for
   each of the cells in the cell library.  The information is help in an
   array of all cells, indexed by identification number, which is initialized
   by program at runtime                                                      */
/*============================================================================*/



/*Initialize a new kind*/
/*Contribute to matrix*/
/*Calculations before updating*/
/*Update memory elements*/
/*Update display*/
/*Relate current of a pin*/
/*First pass of guess*/
/*Second pass of guess*/
/*Checks attribute changes*/
/*Resets memory elements*/
/*Sets state at reset*/
/*Clears state at reset*/
/*Refresh display*/
/*Erase display*/
/*Touch a gate*/
/*Twiddle meters*/
/*Make a new instance*/
/*Copy an instance*/
/*To load in config values*/
/*to read in a gate description*/
/*to write out a gate description*/
/*display a message*/
/*contribute to probe display*/
/*Dispose an old instance*/
typedef enum {
  Analog_act_newkind, Analog_act_ex, Analog_act_preupdate, Analog_act_update,
  Analog_act_display, Analog_act_Iin, Analog_act_pass1, Analog_act_pass2,
  Analog_act_attrchange, Analog_act_reset, Analog_act_set, Analog_act_clear,
  Analog_act_refresh, Analog_act_erase, Analog_act_touch,
  Analog_act_disconnect, Analog_act_newgate, Analog_act_copygate,
  Analog_act_openconfig, Analog_act_readgate, Analog_act_writegate,
  Analog_act_message, Analog_act_probe, Analog_act_disposegate
} Analog_32_actionkinds;


typedef struct Analog_32_action {
  Analog_32_actionkinds action;   /*Desired Action*/
  log_krec *kind;   /*Kind of interest*/
  log_grec *inst;   /*Gate of interest*/
  long pin;   /*Pin of interest*/
  long page;   /*Page of interest*/
  double Iin;   /*Current of pin of interest*/
  boolean ok;   /*An error flag*/
  boolean accepted;   /*Another error flag*/
  Char message[256];   /*A scoreboard message*/
  long messagenum;   /*purpose of message*/
} Analog_32_action;



/******************************************************************************/
/* Each pin of a standard cell will have pin-specific information which will
   involve initital guessing, syntax checking, and simulation. The plist_cell
   structure is an array, dynamically configured to be (# of pins) at
   initialization, which will hold these values.

        Fields:
               standalone: Says if a pin is allowed to be unconnected without
                           underconstraining the system. For example, an
                           inverter would have standalone=true, while a
                           source grounded NMOS transistor's current input
                           would have a value standalone=false. Used for
                           syntax checking

               active:    Says  the pin counts as a connection for syntax
                          checking of other gates.



 {*****************************************************************************/

typedef struct Anapinrec {
  boolean standalone, active;
} Anapinrec;

typedef Anapinrec Anaparray[AnaLarge];



/******************************************************************************/
/* After a successful simulation, all cells that store energy must be allowed
   to update its state. Thus each cell has an procedure pointer for update,
   which may be set to nil for memoryless procedures. This is how cells like
   scopes will communicate its information back to LOG in the final version
   The parameters are the same as for ex_proc. Update phase takes into account
   the ordering of updates; first-phase updates are non-destructive, i.e current
   meters, while second-phase updates are destructive, like system memory.   */
/******************************************************************************/

typedef enum {
  Anasimple, Anacomplex
} Anaupdate_phase;

/*******************************************************************************/
/* A current meter arrow may be pointed at any pin of any gate. To enable
   the operation of this feature, each gate type must have a procedure that
   can return the current into any node a pin is connected to,
   given the nodemap aand attr fields.
 {******************************************************************************/

/******************************************************************************/
/*                    The complete cell descriptor                            */
/******************************************************************************/


typedef struct AnaCell_rec {
  boolean simulatable;   /*Can this gate be simulated?*/
  Void (*proc_cell) PP((Analog_32_action *act));
      /*Procedure for cell execution*/
  long intr_cell;   /*Number of internal variables in cell*/
  Anaupdate_phase phase;   /*Phase of update*/
  Anapinrec *plist_cell;   /*Pin description array of length:pins_cell*/
  Anyptr Ainfo;
} AnaCell_rec;

/******************************************************************************/
/*                    Procedure Type for initialization procedure             */
/******************************************************************************/


/*******************************************************************************/
/*In addition to the list of cell definitions, a list of cell instances
  is also required.                                                            */
/*******************************************************************************/



/*=============================================================================*/
/*  Log keeps a node structure which has an analog node anyptr. In addition,
    gates have an anyptr for analog simulation, a subptr of which will have
    internal node storage. The following ptrs fit in those pages               */
/*=============================================================================*/


typedef struct AnaInt_rec {
  /*Internal Nodes*/
  double ltimestep;   /*Value of last simulation*/
  double last;   /*last value of a simulation*/
  double now;   /*present value of a simulation*/
  long nodenum;   /*Node number for array indexing*/
  struct AnaInt_rec *next;   /*Next internal node*/
} AnaInt_rec;


typedef struct AnaExt_rec {
  /*External Nodes*/
  long refcnt;   /*Marker for syntax checking*/
  boolean Ok_Alone;   /*Marker for syntax checking*/
  double ltimestep;   /*Value of last simulation*/
  double last;   /*last value of a simulation*/
  double now;   /*present value of a simulation*/
  long nodenum;   /*Node number for array indexing*/
  long col_now;   /*color for glow mode*/
  long col_ltimestep;   /*color for glow mode*/
  boolean changed_now;   /*changed flag for glowmode*/
} AnaExt_rec;

/* Each gate also has analog-specific information. */

/*Internal nodelist for each gate*/


typedef struct AnaGate_intnoderec {
  AnaInt_rec *Int_Node;
  struct AnaGate_intnoderec *Next;
} AnaGate_intnoderec;


/* Pin specific information is held in a variable length array.*/


typedef struct AnaInstpinrec {
  double Cap;   /*The capacitance of a pin*/
  double Tau;   /*The last tau of the pin*/
  double Vmem;   /*The voltage memory of a pin*/
  double Vreset;   /*The new voltage for a reset*/
} AnaInstpinrec;

typedef AnaInstpinrec Anapininstarray[AnaLarge];


/*Pointer to list of cells instances*/

typedef struct Anainstlist {
  AnaGate_intnoderec *Gate_nodelist;
  Anyptr InstVar;
  AnaInstpinrec *Pininfo;
  boolean NotReady;
} Anainstlist;

/* **************************************************************************/
/*   To insure swift pen movement regardless of circuit size, I am breaking
     the execution up into units. The following variable deals with this  */
/* **************************************************************************/

typedef enum {
  AnaE_Evaluate, AnaE_Solve, AnaE_Calculate, AnaE_Refresh, AnaE_Adapt,
  AnaE_Memory1, AnaE_Memory2, AnaE_Update
} Anaepochs_type;


/*handles the handshaking for system clock*/


typedef enum {
  Anasettime, Anawait, Anacontinue
} Anatimetype;


/*The color map*/

typedef struct AnaAnalog_Colors {
  short C_Vmeter, C_Imeter, C_Switchon, C_Switchoff, C_Limiton, C_Probe,
	C_Glow1, C_Glow2, C_Glow3, C_Glow4, C_Glow5, C_Glow6;
} AnaAnalog_Colors;


/*Levels for glow mode*/

typedef struct AnaAnalog_Levels {
  long Level_a, Level_b, Level_c, Level_d, Level_e, Level_sum;
} AnaAnalog_Levels;

/*Structure for checking limits of simulation variables*/

typedef union AnaLimcheck {
  long i;
  double r;
} AnaLimcheck;

typedef enum {
  AnaMin, AnaMax
} AnaBounds;

typedef AnaLimcheck AnaCheckarray[AnaParamnum][2];

/*structures for handling commands - Clist is head of list*/


typedef struct AnaCommand_rec {
  Char Command[17];
  Char Arguments[256];
  struct AnaCommand_rec *Next;
} AnaCommand_rec;

/*Types for equation solvers*/
/*Array position 0 is a 'bit-bucket' for vdd & gnd only*/

typedef double AnaMatArray[AnaRowbound + 1][AnaColbound + 1];
typedef boolean AnaMatFlags[AnaRowbound + 1][AnaColbound + 1];

typedef struct AnaMatRec {
  AnaMatArray Mat;
  AnaMatFlags MatNZ;
} AnaMatRec;

typedef enum {
  AnaS_Start, AnaS_Bestrow, AnaS_Divide, AnaS_Subtract, AnaS_Finish
} AnaSolve_Type;

/*Types for log.cnf interface*/


typedef struct AnaKlistnode {
  log_krec *NodeKind;
  struct AnaKlistnode *Nextnode;
} AnaKlistnode;




/*******************************************************************************/
/*System data structures*/

vextern log_action *AnaLogglobals;   /*Log's global variables*/
vextern log_action *AnaLogIglobals;   /*Log's global variables*/
vextern AnaInt_rec *AnaInt_nodelist;   /*List of current internal pointers*/
vextern AnaAnalog_Colors AnaColormap;   /*The color map*/
vextern AnaAnalog_Levels AnaLevelmap;   /*The glow mode level map*/
vextern AnaCheckarray AnaLimits;   /*Array for checking system parameters*/
vextern AnaCommand_rec *AnaClist;   /*Structure for holding cnf commands*/
vextern AnaKlistnode *AnaKlist;   /*Structure for tracking analog gates*/
vextern log_sigrec *AnaVddsig, *Anagndsig;
    /*Signal pointers for Vdd and Gnd*/
vextern log_nrec *AnaVddnode, *Anagndnode;
    /*Signal pointers for Vdd and Gnd*/
/*******************************************************************************/



/*******************************************************************************/
vextern Char AnaCh;   /*Used for 'press any key' debugging*/
/*******************************************************************************/


/*******************************************************************************/
/*Variables that show the state of my simulation and state machine*/

/*Holds state of entire pass procedure*/

vextern boolean AnaReady;   /*Says That a circuit is ready to simulate*/
vextern boolean AnaChanged;   /*Says That a change has been made*/

/*Holds state of simulation proper*/

vextern boolean AnaStart;   /*Indicates whether this is initial timestep*/
vextern boolean AnaError;   /*Simulation flag*/
vextern boolean AnaDone, AnaOverflow;   /*Simulation flags*/
vextern boolean AnaToobig;   /*Simulation flag*/
vextern boolean AnaToosmall;   /*Simulation flag*/
vextern boolean AnaSuccess;   /*Simulation flag*/
vextern long AnaItercount, AnaItermax;
    /*Variables for adaptive iteration watchdog*/
vextern double AnaAccum;   /*Total accumulated timed*/
vextern double AnaDt, AnaDtlast;   /*Present and last timestep of system*/
vextern boolean AnaChangedDt;   /*A new dt has happened*/
vextern boolean AnaChangedP;   /*A transistor parameter has changed*/
vextern boolean AnaInuse;   /*At least one analog gate exists*/
vextern long AnaDtcount;   /*Counting variable to prevent roundoff*/
vextern long AnaRelaxcount;
    /*Comparison variable for Dtcount for relaxation*/
vextern boolean AnaExact;   /*Flag for doing accuracy checking*/
vextern boolean AnaDifficult;   /*Flag for a difficult simulation*/
vextern boolean AnaToomany;   /*Flag for too many iterations*/
vextern boolean AnaErase;   /*State of reset memory*/
vextern boolean AnaOldmodel;   /*Model selection when loading in gates*/
vextern boolean AnaDebugset;   /*Flag used in debugging mode*/
vextern long AnaDebugsize;   /*Number of significant digits for debug mode*/
vextern boolean AnaTimermode;   /*Mode selection for benchmarking*/
vextern boolean AnaTimerstate;   /*State bit for timer state machine*/
vextern long AnaTimerval;   /*Benchmark memory location*/
vextern double AnaVshift;   /*Smallest voltage not requiring a gearshift*/
vextern boolean AnaDimgate;   /*Switch for dimming unconnected gates*/

vextern boolean AnaProbeOn;   /*State of probe mode*/
vextern Char AnaLastnodeStr[256];   /*last node voltage displayed*/
vextern Char AnaLastGate1Str[256];   /*last gate1 message displayed*/
vextern Char AnaLastGate2Str[256];   /*last gate2 message displayed*/
vextern Char AnaLastGate3Str[256];   /*last gate3 message displayed*/
vextern Char AnaLastGate4Str[256];   /*last gate3 message displayed*/
vextern Char AnaLastGate5Str[256];   /*last gate3 message displayed*/

vextern long AnaGateHystercount;   /*Hysteresis counter for probemode*/
vextern long AnaNodeHystercount;   /*Hysteresis counter for probemode*/


/*holds state of state machine*/

vextern Anaepochs_type AnaEpoch;   /*Holds present epoch of simulator*/
vextern long AnaLastpage;   /*Lastpage evaluated;  0->Clear array*/
vextern log_grec *AnaLastgate;   /*Lastgate evaluated*/
vextern Anatimetype AnaTimestate;   /*Present time state of system*/

/*******************************************************************************/


/*******************************************************************************/
/*internal variable for doing watchdog timing*/

/*$if UsingAlarm$
    T1:Timers_desc;            {Variable for watchdog}
    Quit:Boolean;              {Variable for watchdog}
$end$*/

vextern long AnaStoptime;   /*Variable for 'slow' watchdog*/
/*******************************************************************************/


/*******************************************************************************/
/*simulation variables open to the public*/


vextern double AnaVdd;   /*System Power*/
vextern double AnaDtmax;   /*largest allowable timestep*/
vextern double AnaVstep;   /*Maximum voltage step allowed in simulation*/

vextern double AnaHighest;   /*Highest voltage allowed in simulation*/
vextern double AnaLowest;   /*Lowest voltage allowed in simulation*/
vextern double AnaSmall;   /*Guess on a capacitor when Vc=0*/

vextern double AnaTol;   /*Maximum percentage difference for convergance*/
vextern double AnaEqn_Epsilon;   /*epsilon for equation solver*/
vextern double AnaVardone_Epsilon;   /*epsilon for eqn zero test*/

vextern double AnaTimefactor;   /*How much to scale timestep */
vextern double AnaTimemin;   /*lowest allowable timestep */
vextern long AnaIterfirstmax;   /*Number of iterations for first try*/
vextern long AnaTimeincrease;   /*Factor to increase maximum interation by*/
vextern double AnaSrange;   /*Range of optimal voltage steps in simulation*/

vextern double AnaTimerelax;   /*Minimum time to relax accuracy checking*/
vextern double AnaNodecap;   /*Capacitance on a node*/

vextern long AnaProbeprec;   /*Precision of probe mode displays*/
vextern long AnaHysteresis;   /*Amount of Hysteresis in probe mode*/

/*******************************************************************************/

/*******************************************************************************/
/*Variables for equation solver*/

vextern long AnaSysRow, AnaSysCol;
vextern AnaMatRec *AnaSystem;
vextern AnaSolve_Type AnaS_Section;
vextern long AnaLastJ;


/*******************************************************************************/



extern Void AnaAddcommand PP((Char *Keyword, Char *Arg));
extern Void AnaAnalog_ChangeReset PP((int Erase));
extern Void AnaCapattrinsert PP((long base, long attrnum, log_grec *inst,
				 boolean *Ok));
extern Void AnaCapattrload PP((long base, log_grec *inst, int first));
extern Void AnaCapattrread PP((long base, log_grec *inst));
extern Void AnaCapattrwrite PP((long base, log_grec *inst));
extern Void AnaCapCopy PP((log_grec *inst));
extern Void AnaCapDispose PP((log_grec *inst));
extern Void AnaCapex PP((log_grec *inst));
extern Void AnaCapIin PP((Analog_32_action *act));
extern Void AnaCapInit PP((log_grec *inst));
extern Void AnaCappass1 PP((log_grec *inst));
extern Void AnaCappass2 PP((log_grec *inst));
extern Void AnaCapReset PP((log_grec *inst));
extern Void AnaCapUpdate PP((log_grec *inst));
extern Void AnaDiffdump PV();
extern Void AnaDummyGate PP((Analog_32_action *act));
extern Void AnaDummyInit PP((log_krec *dummykindptr));
extern Void AnaGetcommand PP((Char *Keyword, Char *Arg, boolean *Found));
extern Void AnaGetvar PP((Char *Varname, double *Value));
extern Void AnaMatdump PV();
extern Void AnaPopcommand PV();
extern Void AnaTimeinit PV();
extern Void AnaTimeReset PV();
extern Void AnaParamUpdate PV();

extern Void AnaScoreboard PP((Char *Newmessage, long purpose));
extern boolean AnaCrange PP((log_grec *Inst, long Attrnum, int OkZero));
extern boolean AnaDisplayrange PP((log_grec *Inst, long Attrnum));
extern double AnaExpo PP((double V));
extern double AnaSqrt PP((double V));
extern boolean AnaGate_On_Display PP((log_grec *Inst));
extern long AnaGlowVal PP((long Intensity));
extern boolean AnaQuit PV();
extern Char *AnaProbeAmpStr PP((Char *AnaResult, double Val));
extern Char *AnaProbeVoltStr PP((Char *AnaResult, double Val));
extern double AnaTanch PP((double V));


extern boolean AnaVrange PP((log_grec *Inst, long Attrnum));

/*=========================================================================*/
/* These structures, and variables, hold physical and fab constants for    */
/* NFET7/PFET7 series of gates, and related circuits.                      */
/*=========================================================================*/

/* Physical constants, independent of fabrication process */
typedef struct AnaPhysicalConstants {

  double      T;   /* Temperature (degree K)                  */
  double      k;   /* Boltzmann's Constant  (Joules/degree K) */
  double      q;   /* Charge on an electron (Coulombs)        */
  double    e_v;   /* Permittivity of vacumn (F/m)            */
  double    e_s;   /* Permittivity of Si     (F/m)            */
  double   e_ox;   /* Permittivity of SiO2   (F/m)            */

  double     Ut;   /* k*T/q                                   */
} AnaPhysicalConstants;

/* Fabrication parameters, independent of device type         */
typedef struct AnaFabParameters {
  double phi_ms;   /* silicon-oxide interface charge          */

  double     Eg;     /* Bandgap voltage, temperature-dependent  */
  double     ni;     /* ni, temperature-dependent               */
  double lambda;     /* lithography scaling factor              */
  Char fabrun[256];  /* name of fabrication run                 */
  Char process[256]; /* name of fabrication process             */

}AnaFabParameters;

/* Fabrication parameters, different for N/P channel devices  */
typedef struct AnaChannelParameters {
  short     nsign;  /* 1 for nchannel, -1 for pchannel        */

  double      Tox;  /* oxide thickness -- meters              */
  double      psi;  /* potential at depletion edge -- V       */
  double       Na;  /* bulk doping concentration -- 1/cm^3    */
  double      mu0;  /* carrier mobility -- cm^2/(V*s)         */
  double   deltaW;  /* W drawn-->effective correction -- um   */
  double   deltaL;  /* L drawn-->effective correction -- um   */
  double  del_NaS;  /* slope for Na offset dependence         */
  double  Early_s;  /* slope term for Early Effect            */
  double      L_0;  /* intercept term for Early Effect        */

  double      Qss;  /* fixed oxide charge -- C                */
  double  del_Na0;  /* intercept for Na offset dependence     */
  double   del_mu;  /* offset for mobility (unitless)         */

  double aCactive;  /* Capacitance/um^2, active               */
  double   aCwell;  /* Capacitance/um^2, well                 */
  double   linCgs;  /* Capacitance/um, gate-source/drain      */
  double     aCgw;  /* Capacitance/um^2, equiv linear gate C  */

  double      Cox;  /* e_ox/Tox F/m^2                         */
  double       mu;  /* temperature-dependent mobility         */
}AnaChannelParameters;


vextern AnaPhysicalConstants AnaPhysical;
vextern AnaPhysicalConstants AnaMaxPhysical;
vextern AnaPhysicalConstants AnaMinPhysical;
vextern AnaFabParameters AnaGenFab;
vextern AnaFabParameters AnaMaxGenFab;
vextern AnaFabParameters AnaMinGenFab;
vextern AnaChannelParameters AnaNFab;
vextern AnaChannelParameters AnaMaxNFab;
vextern AnaChannelParameters AnaMinNFab;
vextern AnaChannelParameters AnaPFab;
vextern AnaChannelParameters AnaMaxPFab;
vextern AnaChannelParameters AnaMinPFab;

#undef vextern

#endif /*GLOBALS_H*/

/* End. */
